/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.vo;

import com.ksso.scim.ScimResource;
import com.ksso.scim.schema.vo.ScimMembership;
import java.util.Objects;

public class ScimGroupMember
implements ScimMembership,
Comparable<ScimGroupMember> {
    private String value;
    private String display;
    private final ScimResource resource;

    public ScimGroupMember(String value, String display) {
        this(value, display, ScimResource.USERS);
    }

    public ScimGroupMember(String value, String display, ScimResource resource) {
        if (resource != ScimResource.USERS && resource != ScimResource.GROUPS) {
            throw new IllegalArgumentException("Invalid member resource type: " + (Object)((Object)resource));
        }
        this.value = Objects.requireNonNull(value);
        this.display = Objects.requireNonNull(display);
        this.resource = Objects.requireNonNull(resource);
    }

    public boolean isGroup() {
        return this.resource == ScimResource.GROUPS;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    @Override
    public String getType() {
        return this.resource.typeString();
    }

    @Override
    public ScimResource getResource() {
        return this.resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimGroupMember that = (ScimGroupMember)o;
        return this.value.equals(that.value) && this.display.equals(that.display) && this.resource == that.resource;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.display, this.resource});
    }

    public String toString() {
        return "ScimGroupMember{value='" + this.value + '\'' + ", display='" + this.display + '\'' + ", resource=" + (Object)((Object)this.resource) + '}';
    }

    @Override
    public int compareTo(ScimGroupMember o) {
        return this.getValue().compareTo(o.getValue());
    }
}

