/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.vo;

import com.ksso.scim.ScimResource;
import com.ksso.scim.schema.vo.ScimCommonAttr;
import com.ksso.scim.schema.vo.ScimGroupMember;
import com.ksso.scim.schema.vo.ScimObject;
import com.ksso.scim.schema.vo.ScimUserGroup;
import io.vavr.collection.List;
import java.util.Objects;

public class ScimGroup
extends ScimObject {
    private final String displayName;
    private final List<ScimGroupMember> members;

    public ScimGroup(ScimCommonAttr commonAttr, String displayName, List<ScimGroupMember> members) {
        super(commonAttr);
        this.displayName = displayName;
        this.members = members;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<ScimGroupMember> getMembers() {
        return this.members;
    }

    @Override
    public ScimResource getResourceType() {
        return ScimResource.GROUPS;
    }

    public ScimGroupMember toScimGroupMember() {
        return new ScimGroupMember(this.commonAttr.getId(), this.displayName, ScimResource.GROUPS);
    }

    public ScimUserGroup toScimUserGroup() {
        return new ScimUserGroup(this.commonAttr.getId(), this.displayName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScimGroup scimGroup = (ScimGroup)o;
        return this.commonAttr.equals(scimGroup.commonAttr) && this.displayName.equals(scimGroup.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.commonAttr, this.displayName);
    }

    public String toString() {
        return "ScimGroup{commonAttr=" + this.commonAttr + ", displayName='" + this.displayName + "', members=" + this.members + '}';
    }
}

