/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.validation;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.ksso.scim.ScimErrorType;
import com.ksso.scim.ScimResource;
import com.ksso.scim.ScimVersion;
import com.ksso.scim.schema.validation.ValidationError;
import com.ksso.scim.schema.vo.ScimGroupMember;
import com.ksso.scim.schema.vo.ScimMembership;
import com.ksso.scim.schema.vo.ScimName;
import com.ksso.scim.schema.vo.ScimUserEnterpriseAttrs;
import com.ksso.scim.schema.vo.ScimUserGroup;
import com.ksso.scim.util.JsonUtils;
import io.vavr.Function1;
import io.vavr.Tuple2;
import io.vavr.Value;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentValidator {
    private static final Logger log = LoggerFactory.getLogger(FragmentValidator.class);
    private final ScimVersion version;

    public FragmentValidator(ScimVersion version) {
        this.version = version;
    }

    public Validation<ValidationError, JSONObject> validateBody(Option<JSONObject> maybeBody, List<String> requiredSchema) {
        return maybeBody.toValidation(new ValidationError(ScimErrorType.INVALID_SYNTAX, "$", "Empty JSON request body")).map(json -> this.validateSchema((JSONObject)json, (Seq<String>)requiredSchema).map(ignored -> json)).flatMap(Function.identity());
    }

    public Validation<ValidationError, String> validateDescription(String attrName, JSONObject json) {
        String value = json.optString(attrName);
        if (!this.isValidAlphanumericExtra(value, "[-@_\\. ]")) {
            return ValidationError.invalidAttribute(attrName, value);
        }
        return Validation.valid(value);
    }

    public Validation<ValidationError, String> validateGroupName(String attrName, JSONObject json) {
        return this.validateDescription(attrName, json);
    }

    public Validation<ValidationError, String> validateName(String attrName, JSONObject json) {
        String value = json.optString(attrName);
        if (!this.isValidAlphanumericExtra(value, "[-@_\\.']")) {
            return ValidationError.invalidAttribute(attrName, value);
        }
        return Validation.valid(value);
    }

    public Validation<ValidationError, String> validateId(String attributeName, JSONObject json) {
        String value = json.optString(attributeName);
        if (!this.isValidId(value)) {
            return ValidationError.invalidAttribute(attributeName, value);
        }
        return Validation.valid(value);
    }

    private boolean isValidId(String value) {
        return this.isValidAlphanumericExtra(value, "[-_]");
    }

    public boolean isValidAlphanumericExtra(String value, String extraAllowableRegex) {
        return StringUtils.isAlphanumeric(RegExUtils.removeAll(value, extraAllowableRegex));
    }

    public Validation<ValidationError, String> validateResourceId(String resourceId, JSONObject json) {
        String jsonId = json.optString("id");
        if (!this.isValidId(resourceId)) {
            return ValidationError.invalidAttribute("id", resourceId);
        }
        if (StringUtils.isNotBlank(jsonId) && !StringUtils.equals(resourceId, jsonId)) {
            return ValidationError.resourceIdMismatch("id", resourceId, jsonId);
        }
        return Validation.valid(resourceId);
    }

    public Validation<ValidationError, ScimName> validateScimName(JSONObject json) {
        JSONObject nameJson = json.optJSONObject("name");
        if (nameJson == null) {
            return ValidationError.requiredAttributeMissing("name");
        }
        String familyName = nameJson.optString("familyName");
        String givenName = nameJson.optString("givenName");
        String formatted = nameJson.optString("formatted", StringUtils.trimToNull(givenName + " " + familyName));
        return Try.of(() -> new ScimName(formatted, familyName, givenName)).toValidation().mapError(t -> new ValidationError(ScimErrorType.INVALID_SYNTAX, "name", "Invalid name: " + t.getMessage()));
    }

    public Validation<ValidationError, Void> validateSchema(JSONObject json, Seq<String> requiredSchema) {
        List<String> schemas = Option.of(json.optJSONArray("schemas")).map(JsonUtils::stringStream).map(Value::toList).getOrElse(List.empty());
        if (!schemas.containsAll(requiredSchema)) {
            log.debug("Missing required schemas, found {}, expected\u00a0{}", (Object)schemas.mkString(), (Object)requiredSchema.mkString());
        }
        return Validation.valid(null);
    }

    public <T extends ScimMembership> Validation<ValidationError, List<T>> validateMemberships(JSONArray memberships, Function1<JSONObject, Validation<Seq<ValidationError>, T>> membershipValidator) {
        if (memberships == null) {
            return Validation.valid(List.empty());
        }
        Tuple2<Stream<Validation>, Stream<Validation>> partitions = JsonUtils.jsonObjectStream(memberships).map(json -> (Validation)membershipValidator.apply((JSONObject)json)).partition(Validation::isValid);
        Value firstValidationError = ((Stream)partitions._2).headOption().map(v -> (ValidationError)((Seq)v.getError()).head());
        if (firstValidationError.isDefined()) {
            ValidationError v2 = (ValidationError)firstValidationError.get();
            return Validation.invalid(new ValidationError(v2.getErrorType(), "Errors in memberships: " + v2.getDescription()));
        }
        return Validation.valid(((Stream)partitions._1).map(Validation::get).toList());
    }

    public Validation<Seq<ValidationError>, ScimGroupMember> validateGroupMember(JSONObject json) {
        Validation<ValidationError, String> valueValidation = this.validateId("value", json);
        Validation resourceValidation = Option.of(json.optString("type", null)).map(type -> ScimResource.fromTypeString(type).toValidation(new ValidationError(ScimErrorType.INVALID_SYNTAX, type + " is not a valid group member type"))).getOrElse(Validation.valid(ScimResource.USERS));
        String displayName = json.optString("display");
        return Validation.combine(valueValidation, resourceValidation).ap((value, resource) -> new ScimGroupMember((String)value, displayName, (ScimResource)((Object)resource)));
    }

    public Validation<Seq<ValidationError>, ScimUserGroup> validateUserGroup(JSONObject json) {
        Validation<ValidationError, String> valueValidation = this.validateId("value", json);
        Validation typeValidation = Option.of(json.optString("type", null)).map(type -> Try.of(() -> ScimUserGroup.Type.fromTypeString(type)).filter(t -> t == ScimUserGroup.Type.DIRECT).toValidation().mapError(t -> new ValidationError(ScimErrorType.INVALID_SYNTAX, "Not a valid type for user modification: " + type))).getOrElse(Validation.valid(ScimUserGroup.Type.DIRECT));
        if (typeValidation.isInvalid()) {
            return Validation.invalid(List.of(typeValidation.getError()));
        }
        String displayName = json.optString("display");
        return Validation.combine(valueValidation, typeValidation).ap((value, type) -> new ScimUserGroup((String)value, displayName, (ScimUserGroup.Type)((Object)type)));
    }

    public Option<String> findMultiValuePrimary(JSONArray array) {
        return FragmentValidator.findMultiValue(array, obj -> obj.optBoolean("primary", false));
    }

    public Option<String> findMultiValuePrimaryWithFallback(JSONArray array) {
        return FragmentValidator.findMultiValueWithFallback(array, obj -> obj.optBoolean("primary", false));
    }

    private static Option<String> findMultiValue(JSONArray array, Predicate<JSONObject> pred) {
        if (array == null || array.length() == 0) {
            return Option.none();
        }
        for (int i = 0; i < array.length(); ++i) {
            JSONObject obj = array.getJSONObject(i);
            if (!pred.test(obj)) continue;
            return Option.of(obj.getString("value"));
        }
        return Option.none();
    }

    private static Option<String> findMultiValueWithFallback(JSONArray array, Predicate<JSONObject> pred) {
        if (array == null || array.length() == 0) {
            return Option.none();
        }
        for (int i = 0; i < array.length(); ++i) {
            JSONObject obj2 = array.getJSONObject(i);
            if (!pred.test(obj2)) continue;
            return Option.of(obj2.getString("value"));
        }
        return Option.of(array.getJSONObject(0)).map(obj -> obj.getString("value"));
    }

    public Validation<ValidationError, ScimUserEnterpriseAttrs> validateUserEnterpriseAttrs(JSONObject json) {
        JSONObject container = json.optJSONObject("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
        if (container == null) {
            return Validation.valid(ScimUserEnterpriseAttrs.none());
        }
        JSONObject manager = container.optJSONObject("manager");
        if (manager == null) {
            return Validation.valid(ScimUserEnterpriseAttrs.none());
        }
        Option<String> managerId = Option.of(manager.optString("value"));
        if (managerId.isEmpty()) {
            return ValidationError.requiredAttributeMissing("manager.value");
        }
        return Validation.valid(new ScimUserEnterpriseAttrs(managerId));
    }
}

