/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.requests;

import com.ksso.scim.schema.vo.ScimName;
import com.ksso.scim.schema.vo.ScimUserEnterpriseAttrs;
import com.ksso.scim.schema.vo.ScimUserGroup;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.util.Objects;

public class CreateUserRequest {
    private final String userName;
    private final String email;
    private final String externalId;
    private final ScimName name;
    private final boolean active;
    private final List<ScimUserGroup> groups;
    private final ScimUserEnterpriseAttrs enterpriseAttrs;

    public CreateUserRequest(String userName, String email, String externalId, ScimName name, List<ScimUserGroup> groups2, boolean active) {
        this(userName, email, externalId, name, groups2, active, ScimUserEnterpriseAttrs.none());
    }

    public CreateUserRequest(String userName, String email, String externalId, ScimName name, List<ScimUserGroup> groups2, boolean active, ScimUserEnterpriseAttrs enterpriseAttrs) {
        this.userName = Objects.requireNonNull(userName);
        this.name = Objects.requireNonNull(name);
        this.groups = Objects.requireNonNull(groups2);
        this.externalId = externalId;
        this.email = email;
        this.active = active;
        this.enterpriseAttrs = enterpriseAttrs;
    }

    public CreateUserRequest(CreateUserRequest other) {
        this(other.userName, other.email, other.externalId, other.name, other.groups, other.active, other.enterpriseAttrs);
    }

    public String getUserName() {
        return this.userName;
    }

    public ScimName getName() {
        return this.name;
    }

    public Option<String> getEmail() {
        return Option.of(this.email);
    }

    public Option<String> getExternalId() {
        return Option.of(this.externalId);
    }

    public boolean isActive() {
        return this.active;
    }

    public List<ScimUserGroup> getGroups() {
        return this.groups;
    }

    public ScimUserEnterpriseAttrs getEnterpriseAttrs() {
        return this.enterpriseAttrs;
    }
}

