/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.marshaller;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.ksso.scim.MetaUrlBuilder;
import com.ksso.scim.ScimResource;
import com.ksso.scim.ScimVersion;
import com.ksso.scim.schema.marshaller.ResponseAttributeFilter;
import com.ksso.scim.schema.vo.ScimGroup;
import com.ksso.scim.schema.vo.ScimMembership;
import com.ksso.scim.schema.vo.ScimName;
import com.ksso.scim.schema.vo.ScimObject;
import com.ksso.scim.schema.vo.ScimUser;
import com.ksso.scim.schema.vo.ScimUserEnterpriseAttrs;
import io.vavr.Function1;
import io.vavr.collection.List;
import java.time.format.DateTimeFormatter;

public class FragmentMarshaller {
    private final ScimVersion version;
    private final ResponseAttributeFilter responseAttributeFilter;
    private final MetaUrlBuilder metaUrlBuilder;

    public FragmentMarshaller(ScimVersion version, ResponseAttributeFilter responseAttributeFilter, MetaUrlBuilder metaUrlBuilder) {
        this.version = version;
        this.responseAttributeFilter = responseAttributeFilter;
        this.metaUrlBuilder = metaUrlBuilder;
    }

    public JSONObject userJson(ScimUser user) {
        ScimUserEnterpriseAttrs enterpriseAttrs;
        String primarySchema = this.version.fold(() -> "urn:scim:schemas:core:1.0", () -> "urn:ietf:params:scim:schemas:core:2.0:User");
        String enterpriseSchema = this.version.fold(() -> "urn:scim:schemas:extension:enterprise:1.0", () -> "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
        JSONObject json = new JSONObject().put("schemas", new JSONArray().put(primarySchema).put(enterpriseSchema)).put("id", user.getId());
        user.getExternalId().peek(externalId -> json.put("externalId", externalId));
        if (this.responseAttributeFilter.accept("userName")) {
            json.put("userName", user.getUserName());
        }
        if (this.responseAttributeFilter.accept("emails")) {
            json.put("emails", this.emails(user.getEmail()));
        }
        if (this.responseAttributeFilter.accept("name")) {
            json.put("name", this.name(user.getName()));
        }
        if (this.responseAttributeFilter.accept("active")) {
            json.put("active", user.isActive());
        }
        if (this.responseAttributeFilter.accept("groups")) {
            json.put("groups", this.membershipListJson(user.getGroups()));
        }
        if ((enterpriseAttrs = user.getEnterpriseAttr()).isDefined() && this.responseAttributeFilter.accept(enterpriseSchema)) {
            enterpriseAttrs.getManagerId().peek(managerId -> json.put(enterpriseSchema, new JSONObject().put("manager", new JSONObject().put("value", managerId).put("$ref", String.format("../%s/%s", ScimResource.USERS.endpointValue(this.version), managerId)))));
        }
        json.put("meta", this.metaJson(user));
        return json;
    }

    public <T> JSONObject jsonListResponse(List<T> items, int startIndex, int itemsPerPage, int totalResults, Function1<T, JSONObject> itemMapper) {
        return new JSONObject().put("schemas", new JSONArray().put(this.version.fold(() -> "urn:scim:schemas:core:1.0", () -> "urn:ietf:params:scim:api:messages:2.0:ListResponse"))).put("totalResults", totalResults).put("itemsPerPage", itemsPerPage).put("startIndex", startIndex).put("Resources", items.map(itemMapper).foldLeft(new JSONArray(), JSONArray::put));
    }

    public JSONArray emails(String email) {
        return new JSONArray().put(new JSONObject().put("primary", true).put("value", email).put("type", "work"));
    }

    public JSONObject name(ScimName name) {
        JSONObject json = new JSONObject().put("formatted", name.getFormatted());
        name.getGivenName().peek(givenName -> json.put("givenName", givenName));
        name.getFamilyName().peek(familyName -> json.put("familyName", familyName));
        return json;
    }

    public JSONObject metaJson(ScimObject scimObject) {
        DateTimeFormatter dtf = DateTimeFormatter.ISO_INSTANT;
        JSONObject meta = new JSONObject().put("created", dtf.format(scimObject.getCreated())).put("lastModified", dtf.format(scimObject.getLastModified())).put("location", this.metaUrlBuilder.url(scimObject.getResourceType(), scimObject.getId())).put("version", scimObject.weakEtag());
        if (this.version == ScimVersion.V2_0) {
            meta.put("resourceType", scimObject.getResourceType().typeString());
        }
        return meta;
    }

    public JSONObject groupJson(ScimGroup group) {
        String schema = this.version.fold(() -> "urn:scim:schemas:core:1.0", () -> "urn:ietf:params:scim:schemas:core:2.0:Group");
        JSONObject json = new JSONObject().put("schemas", new JSONArray().put(schema)).put("id", group.getId());
        if (this.responseAttributeFilter.accept("displayName")) {
            json.put("displayName", group.getDisplayName());
        }
        if (this.responseAttributeFilter.accept("members")) {
            json.put("members", this.membershipListJson(group.getMembers()));
        }
        json.put("meta", this.metaJson(group));
        return json;
    }

    public JSONArray membershipListJson(List<? extends ScimMembership> memberships) {
        return memberships.foldLeft(new JSONArray(), (arr, membership) -> arr.put(this.membership((ScimMembership)membership)));
    }

    public JSONObject membership(ScimMembership membership) {
        JSONObject json = new JSONObject().put("value", membership.getValue()).put("display", membership.getDisplay());
        if (this.version == ScimVersion.V2_0) {
            json = json.put("type", membership.getType()).put("$ref", this.metaUrlBuilder.url(membership.getResource(), membership.getValue()));
        }
        return json;
    }
}

