/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.evaluation.json;

import com.atlassian.json.jsonorg.JSONElement;
import com.ksso.scim.ScimErrorType;
import com.ksso.scim.schema.evaluation.json.JsonElementContext;
import com.ksso.scim.schema.evaluation.json.MutationContext;
import com.ksso.scim.schema.evaluation.json.MutationTerminatingContext;
import com.ksso.scim.schema.validation.ValidationError;
import io.vavr.control.Option;
import io.vavr.control.Validation;
import java.util.Objects;

abstract class JsonValueContext<V>
implements MutationContext,
MutationTerminatingContext {
    private final JsonElementContext parent;
    private final Option<String> maybeKey;
    final V value;

    public JsonValueContext(JsonElementContext parentCtx, Option<String> maybeKey, V value) {
        this.parent = Objects.requireNonNull(parentCtx);
        this.maybeKey = Objects.requireNonNull(maybeKey);
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Validation<ValidationError, Void> addValue(Object newValue) {
        return this.replace(newValue);
    }

    @Override
    public Validation<ValidationError, Void> replace(Object newValue) {
        if (newValue instanceof JSONElement) {
            return Validation.invalid(new ValidationError(ScimErrorType.INVALID_VALUE, this.maybeKey + ": value must be a primitive type"));
        }
        return this.parent.replaceDescendant(this.maybeKey, this.value, newValue);
    }

    @Override
    public Validation<ValidationError, Void> remove() {
        return this.parent.removeDescendant(this.maybeKey, this.value);
    }
}

