/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.evaluation.json;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.ksso.scim.schema.evaluation.json.JsonArrayContext;
import com.ksso.scim.schema.evaluation.json.JsonBooleanContext;
import com.ksso.scim.schema.evaluation.json.JsonContainerContext;
import com.ksso.scim.schema.evaluation.json.JsonDateTimeContext;
import com.ksso.scim.schema.evaluation.json.JsonIntegerContext;
import com.ksso.scim.schema.evaluation.json.JsonStringContext;
import com.ksso.scim.schema.evaluation.json.MutationContainerContext;
import com.ksso.scim.schema.evaluation.json.MutationContext;
import com.ksso.scim.schema.validation.ValidationError;
import com.ksso.scim.util.JsonUtils;
import io.vavr.collection.CharSeq;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import io.vavr.control.Validation;
import java.time.Instant;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public abstract class JsonElementContext
implements MutationContainerContext {
    private static final String SELF = "$";
    private static final List<CharSeq> CORE_SCHEMA = List.of("urn:scim:schemas:core:1.0", "urn:ietf:params:scim:schemas:core:2.0:User", "urn:ietf:params:scim:schemas:core:2.0:Group").map(CharSeq::of);

    @Override
    public <T extends MutationContext> List<T> resolve(Seq<String> path) {
        return this.resolve(this, path);
    }

    <T extends MutationContext> List<T> resolve(MutationContainerContext ctx, Seq<String> path) {
        Function<MutationContext, MutationContext> TYPECAST = t -> t;
        if (path.isEmpty()) {
            return List.of(ctx).map(TYPECAST);
        }
        LinearSeq next = ctx.getElementByKey((String)path.head()).map(TYPECAST);
        if (path.tail().isEmpty()) {
            return next;
        }
        return next.map(n1 -> (MutationContainerContext)n1).map(nextContainer -> this.resolve((MutationContainerContext)nextContainer, (Seq<String>)path.tail())).flatMap(Function.identity()).map(TYPECAST);
    }

    MutationContext toMutationContext(Option<String> maybeKey, Object value) {
        if (value instanceof JSONObject) {
            return new JsonContainerContext(maybeKey, Option.of(this), (JSONObject)value);
        }
        if (value instanceof JSONArray) {
            return new JsonArrayContext(maybeKey.get(), this, (JSONArray)value);
        }
        if (value instanceof Boolean) {
            return new JsonBooleanContext(this, maybeKey, (Boolean)value);
        }
        if (value instanceof Integer) {
            return new JsonIntegerContext(this, maybeKey, (Integer)value);
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            String key = maybeKey.getOrElse("");
            if (StringUtils.equals(key, "created") || StringUtils.equals(key, "lastModified")) {
                Instant instant = JsonUtils.dateTimeToInstant(stringValue);
                return new JsonDateTimeContext(this, maybeKey, instant);
            }
            return new JsonStringContext(this, maybeKey, false, stringValue);
        }
        throw new RuntimeException("Unrecognized key '" + maybeKey + "' with value of type " + value.getClass());
    }

    abstract Validation<ValidationError, Void> replaceDescendant(Option<String> var1, Object var2, Object var3);

    abstract Validation<ValidationError, Void> removeDescendant(Option<String> var1, Object var2);

    static void addValueToJsonArray(JSONArray jsonArray, Object value) {
        if (value instanceof JSONArray) {
            JsonUtils.stream((JSONArray)value, (idx, arr) -> arr.get((int)idx)).forEach(jsonArray::put);
        } else {
            jsonArray.put(value);
        }
    }
}

