/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.schema.evaluation.json;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.ksso.scim.ScimErrorType;
import com.ksso.scim.patch.AttributeFilterEvaluationVisitor;
import com.ksso.scim.schema.evaluation.json.JsonElementContext;
import com.ksso.scim.schema.evaluation.json.MutationContainerContext;
import com.ksso.scim.schema.evaluation.json.MutationContext;
import com.ksso.scim.schema.validation.ValidationError;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import io.vavr.control.Validation;
import java.util.Iterator;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;

public class JsonArrayContext
extends JsonElementContext {
    private final String key;
    private final JsonElementContext parent;
    private final JSONArray jsonArray;

    public JsonArrayContext(String key, JsonElementContext parent, JSONArray jsonArray) {
        this.key = Objects.requireNonNull(key);
        this.parent = Objects.requireNonNull(parent);
        this.jsonArray = Objects.requireNonNull(jsonArray);
    }

    @Override
    public Object getValue() {
        return this.jsonArray;
    }

    @Override
    public List<MutationContext> getElementByKey(String key) {
        LinearSeq list = List.empty();
        for (int idx = 0; idx < this.jsonArray.length(); ++idx) {
            MutationContext arrayItem = this.toMutationContext(Option.none(), this.jsonArray.get(idx));
            if (arrayItem instanceof MutationContainerContext) {
                List<MutationContext> arrayValues = ((MutationContainerContext)arrayItem).getElementByKey(key);
                list = list.appendAll(arrayValues);
                continue;
            }
            list = list.append(arrayItem);
        }
        return List.ofAll(list);
    }

    @Override
    public List<MutationContext> getByValueSelectionFilter(ParseTree filter) {
        return List.ofAll(io.vavr.collection.Iterator.ofAll(this.jsonArray.iterator())).map(arrayElement -> this.toMutationContext(Option.none(), arrayElement)).filter(mc -> mc instanceof MutationContainerContext).filter(mc -> (Boolean)new AttributeFilterEvaluationVisitor((MutationContext)mc).visit(filter));
    }

    @Override
    public boolean evaluate(String operator, String criteria) {
        return false;
    }

    @Override
    public Validation<ValidationError, Void> insertValue(Seq<String> path, Object value) {
        String thisKey = (String)path.head();
        Traversable tail = path.tail();
        if (tail.isEmpty()) {
            this.jsonArray.put(value);
            return Validation.valid(null);
        }
        if (this.jsonArray.length() == 0) {
            this.jsonArray.put(new JSONObject());
        }
        for (int i = 0; i < this.jsonArray.length(); ++i) {
            Object item = this.jsonArray.get(i);
            MutationContext mc = this.toMutationContext(Option.none(), item);
            Validation<ValidationError, Void> v = mc instanceof MutationContainerContext ? ((MutationContainerContext)mc).insertValue((Seq<String>)tail, value) : Validation.invalid(new ValidationError(ScimErrorType.INVALID_PATH, String.format("%s along path %s is a primitive value, further insertion not possible", thisKey, path.mkString("."))));
            if (!v.isInvalid()) continue;
            return v;
        }
        return Validation.valid(null);
    }

    @Override
    public Validation<ValidationError, Void> addValue(Object newValue) {
        JsonArrayContext.addValueToJsonArray(this.jsonArray, newValue);
        return Validation.valid(null);
    }

    @Override
    public Validation<ValidationError, Void> replace(Object value) {
        if (!(value instanceof JSONArray)) {
            return Validation.invalid(new ValidationError(ScimErrorType.INVALID_VALUE, this.key + "can't be replaced: Value must be JSONArray, found: " + value.getClass().getSimpleName()));
        }
        this.parent.removeDescendant(Option.of(this.key), this.jsonArray);
        JSONObject newValue = new JSONObject().put(this.key, value);
        return this.parent.addValue(newValue);
    }

    @Override
    Validation<ValidationError, Void> replaceDescendant(Option<String> maybeKey, Object oldValue, Object value) {
        for (int i = 0; i < this.jsonArray.length(); ++i) {
            Object o = this.jsonArray.get(i);
            if (!o.equals(oldValue)) continue;
            this.jsonArray.put(i, value);
        }
        return Validation.valid(null);
    }

    @Override
    Validation<ValidationError, Void> removeDescendant(Option<String> maybeKey, Object value) {
        Iterator<Object> it = this.jsonArray.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(value)) continue;
            it.remove();
        }
        return Validation.valid(null);
    }

    @Override
    public Validation<ValidationError, Void> remove() {
        return this.parent.removeDescendant(Option.of(this.key), this.jsonArray);
    }

    public String toString() {
        return "JsonArrayContext{key='" + this.key + '\'' + '}';
    }
}

