/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.patch;

import com.atlassian.json.jsonorg.JSONArray;
import com.ksso.scim.filter.ScimFilterParser;
import com.ksso.scim.schema.requests.AddMembershipRequest;
import com.ksso.scim.schema.requests.MembershipRequest;
import com.ksso.scim.schema.requests.RemoveMembershipRequest;
import com.ksso.scim.schema.requests.ReplaceMembersRequest;
import com.ksso.scim.schema.validation.ValidationError;
import com.ksso.scim.util.JsonUtils;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Validation;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class PatchOperation {
    private final ScimFilterParser.PatchPathContext ppc;
    private final Type type;
    private final String rawPath;
    private final Object value;

    public PatchOperation(Type type, ScimFilterParser.PatchPathContext ppc, String rawPath, Object value) {
        this.type = Objects.requireNonNull(type);
        this.ppc = Objects.requireNonNull(ppc);
        this.rawPath = rawPath;
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public ScimFilterParser.PatchPathContext getPath() {
        return this.ppc;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public Object getValue() {
        return this.value;
    }

    public Validation<Seq<ValidationError>, Either<PatchOperation, MembershipRequest>> splitOutMembershipOp(String gid) {
        if (this.rawPath.contains("members")) {
            return this.type.fold(() -> {
                if (this.value instanceof JSONArray) {
                    List<String> values2 = JsonUtils.jsonObjectStream(this.value).map(jsonObj -> Option.of(jsonObj.getString("value")).getOrElse("")).filter(value -> value.length() > 0).toList();
                    if (values2.isEmpty()) {
                        return ValidationError.invalidAttributeSeq("value", "The 'value' field must contain an array with userids {value:<userId>}");
                    }
                    return Validation.valid(Either.right(new AddMembershipRequest(gid, values2)));
                }
                return ValidationError.invalidAttributeSeq("value", "The 'value' field must contain an array with userids {value:<userId>}");
            }, () -> {
                String userId = StringUtils.substringBefore(StringUtils.substringAfter(this.rawPath, "value eq \""), "\"]");
                if (userId.isEmpty()) {
                    List<String> values2 = JsonUtils.jsonObjectStream(this.value).map(jsonObj -> Option.of(jsonObj.getString("value")).getOrElse("")).filter(value -> value.length() > 0).toList();
                    if (values2.isEmpty()) {
                        return Validation.valid(Either.right(new ReplaceMembersRequest(gid, List.empty())));
                    }
                    return Validation.valid(Either.right(new RemoveMembershipRequest(gid, values2)));
                }
                return Validation.valid(Either.right(new RemoveMembershipRequest(gid, List.of(userId))));
            }, () -> {
                if (this.value instanceof JSONArray) {
                    List<String> values2 = JsonUtils.jsonObjectStream((JSONArray)this.value).map(jsonObj -> Option.of(jsonObj.getString("value")).getOrElse("")).filter(value -> value.length() > 0).toList();
                    if (values2.isEmpty()) {
                        return ValidationError.invalidAttributeSeq("value", "The 'value' field must contain an array with userids {value:<userId>}");
                    }
                    return Validation.valid(Either.right(new ReplaceMembersRequest(gid, values2)));
                }
                return ValidationError.invalidAttributeSeq("value", "The 'value' field must contain an array with userids {value:<userId>}");
            });
        }
        return Validation.valid(Either.left(this));
    }

    public String toString() {
        return "PatchOperation{type=" + (Object)((Object)this.type) + ", path='" + this.ppc.getText() + '\'' + ", value=" + this.value + '}';
    }

    public static enum Type {
        ADD{

            @Override
            public <T> T fold(Supplier<T> onAdd, Supplier<T> onRemove, Supplier<T> onReplace) {
                return onAdd.get();
            }
        }
        ,
        REMOVE{

            @Override
            public <T> T fold(Supplier<T> onAdd, Supplier<T> onRemove, Supplier<T> onReplace) {
                return onRemove.get();
            }
        }
        ,
        REPLACE{

            @Override
            public <T> T fold(Supplier<T> onAdd, Supplier<T> onRemove, Supplier<T> onReplace) {
                return onReplace.get();
            }
        };


        public abstract <T> T fold(Supplier<T> var1, Supplier<T> var2, Supplier<T> var3);
    }
}

