/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.patch;

import com.ksso.scim.ScimErrorType;
import com.ksso.scim.filter.ScimFilterBaseVisitor;
import com.ksso.scim.filter.ScimFilterParser;
import com.ksso.scim.patch.PatchOperation;
import com.ksso.scim.patch.PatchUtil;
import com.ksso.scim.schema.evaluation.json.MutationContainerContext;
import com.ksso.scim.schema.evaluation.json.MutationContext;
import com.ksso.scim.schema.validation.ValidationError;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Seq;
import io.vavr.control.Validation;
import java.util.function.Function;
import org.antlr.v4.runtime.tree.ParseTree;

public class JsonPatchAttributeVisitor
extends ScimFilterBaseVisitor<Validation<ValidationError, Void>> {
    private final MutationContainerContext containerContext;
    private final PatchOperation patchOp;

    public JsonPatchAttributeVisitor(MutationContainerContext containerContext, PatchOperation patchOp) {
        this.containerContext = containerContext;
        this.patchOp = patchOp;
    }

    @Override
    public Validation<ValidationError, Void> visitPatchAttribute(ScimFilterParser.PatchAttributeContext ctx) {
        Seq<String> attrPath = PatchUtil.toPathList(ctx.attrPath());
        Object value = this.patchOp.getValue();
        List<MutationContainerContext> bases = List.of(this.containerContext);
        return this.applyOrInsert(attrPath, value, bases);
    }

    @Override
    public Validation<ValidationError, Void> visitPatchAttributeFiltered(ScimFilterParser.PatchAttributeFilteredContext ctx) {
        ScimFilterParser.AttrFilterContext afc = ctx.attrFilter();
        Seq<String> path = PatchUtil.toPathList(afc.attrPath());
        ScimFilterParser.ExprContext valueSelectionFilter = afc.expr();
        List<MutationContext> targets = this.containerContext.resolve(path);
        if (targets.find(mc -> !(mc instanceof MutationContainerContext)).isDefined()) {
            return Validation.invalid(new ValidationError(ScimErrorType.INVALID_PATH, String.format("'%s' is not a container context, attribute selection filters cannot be applied to such elements", path)));
        }
        LinearSeq resolved = targets.map(mc -> (MutationContainerContext)mc).map(mc -> mc.getByValueSelectionFilter(valueSelectionFilter)).flatMap(list -> list);
        if (resolved.isEmpty()) {
            return Validation.invalid(new ValidationError(ScimErrorType.NO_TARGET, String.format("value selection filter doesn't match any records (%s)", this.patchOp.getRawPath())));
        }
        LinearSeq remainder = List.ofAll(ctx.ATTRNAME()).map(ParseTree::getText);
        if (remainder.isEmpty()) {
            return this.apply(this.patchOp.getValue(), (List<MutationContext>)resolved);
        }
        LinearSeq resolvedBases = resolved.filter(r -> r instanceof MutationContainerContext).map(r -> (MutationContainerContext)r);
        return this.applyOrInsert(remainder, this.patchOp.getValue(), (List<MutationContainerContext>)resolvedBases);
    }

    private Validation<ValidationError, Void> applyOrInsert(Seq<String> attrPath, Object value, List<MutationContainerContext> resolveBases) {
        LinearSeq resolved = resolveBases.map(base -> base.resolve(attrPath)).flatMap(list -> list);
        if (resolved.isEmpty() && JsonPatchAttributeVisitor.shouldMakeParents(this.patchOp.getType())) {
            for (MutationContainerContext base2 : resolveBases) {
                Validation<ValidationError, Void> validation = base2.insertValue(attrPath, value);
                if (!validation.isInvalid()) continue;
                return validation;
            }
            return Validation.valid(null);
        }
        return this.apply(value, (List<MutationContext>)resolved);
    }

    private Validation<ValidationError, Void> apply(Object value, List<MutationContext> resolvedTargets) {
        PatchOperation.Type type = this.patchOp.getType();
        Function patchFunc = type.fold(() -> mc -> mc.addValue(value), () -> mc -> mc.remove(), () -> mc -> mc.replace(value));
        return resolvedTargets.map(patchFunc).find(Validation::isInvalid).getOrElse(Validation.valid(null));
    }

    private static boolean shouldMakeParents(PatchOperation.Type type) {
        return type == PatchOperation.Type.ADD || type == PatchOperation.Type.REPLACE;
    }
}

