/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.patch;

import com.ksso.scim.filter.ScimFilterBaseVisitor;
import com.ksso.scim.filter.ScimFilterParser;
import com.ksso.scim.patch.PatchUtil;
import com.ksso.scim.schema.evaluation.json.MutationContainerContext;
import com.ksso.scim.schema.evaluation.json.MutationContext;
import com.ksso.scim.util.StrUtil;
import io.vavr.collection.Seq;
import org.apache.commons.lang3.BooleanUtils;

public class AttributeFilterEvaluationVisitor
extends ScimFilterBaseVisitor<Boolean> {
    private final MutationContainerContext containerContext;

    public AttributeFilterEvaluationVisitor(MutationContext evc) {
        if (!(evc instanceof MutationContainerContext)) {
            throw new RuntimeException("Cannot evaluate SCIM filter on top of non-container context: " + evc.getClass().getSimpleName());
        }
        this.containerContext = (MutationContainerContext)evc;
    }

    @Override
    public Boolean visitFilter(ScimFilterParser.FilterContext ctx) {
        return (Boolean)super.visit(ctx.expr());
    }

    @Override
    public Boolean visitOperatorExpr(ScimFilterParser.OperatorExprContext ctx) {
        Seq<String> attrPath = PatchUtil.toPathList(ctx.attrPath());
        String operator = ctx.OPERATOR().getText();
        String criteria = StrUtil.unwrap(ctx.CRITERIA().getText(), "\"");
        return this.containerContext.resolve(attrPath).map(ec -> ec.evaluate(operator, criteria)).filter(BooleanUtils::isTrue).getOrElse(false);
    }

    @Override
    public Boolean visitAttrFilterExpr(ScimFilterParser.AttrFilterExprContext ctx) {
        ScimFilterParser.AttrFilterContext afc = ctx.attrFilter();
        Seq<String> attrPath = PatchUtil.toPathList(afc.attrPath());
        return this.containerContext.resolve(attrPath).map(AttributeFilterEvaluationVisitor::new).map(v -> (Boolean)v.visit(afc.expr())).find(BooleanUtils::isTrue).getOrElse(Boolean.FALSE);
    }

    @Override
    public Boolean visitPresentExpr(ScimFilterParser.PresentExprContext ctx) {
        Seq<String> attrPath = PatchUtil.toPathList(ctx.attrPath());
        return this.containerContext.resolve(attrPath).map(ev -> ev.evaluate("pr", null)).filter(BooleanUtils::isTrue).getOrElse(false);
    }

    @Override
    public Boolean visitAndExpr(ScimFilterParser.AndExprContext ctx) {
        return (Boolean)this.visit(ctx.expr(0)) != false && (Boolean)this.visit(ctx.expr(1)) != false;
    }

    @Override
    public Boolean visitOrExpr(ScimFilterParser.OrExprContext ctx) {
        return (Boolean)this.visit(ctx.expr(0)) != false || (Boolean)this.visit(ctx.expr(1)) != false;
    }

    @Override
    public Boolean visitNotExpr(ScimFilterParser.NotExprContext ctx) {
        return (Boolean)super.visit(ctx.expr()) == false;
    }

    @Override
    public Boolean visitGroupExpr(ScimFilterParser.GroupExprContext ctx) {
        return (Boolean)super.visit(ctx.expr());
    }
}

