/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.atlassian.repository;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.ksso.scim.SearchResult;
import com.ksso.scim.atlassian.repository.AtlassianUserRepositoryException;
import com.ksso.scim.atlassian.repository.QueryTransformer;
import com.ksso.scim.schema.requests.SearchRequest;
import com.ksso.scim.spi.SpiError;
import io.vavr.collection.List;
import io.vavr.collection.Stream;

public class ScimDirectorySearch {
    private final DirectoryManager directoryManager;
    private final Directory directory;
    private final QueryTransformer queryTransformer;

    public ScimDirectorySearch(DirectoryManager directoryManager, Directory directory) {
        this.directoryManager = directoryManager;
        this.directory = directory;
        this.queryTransformer = new QueryTransformer();
    }

    public SearchResult<String> searchGroups(SearchRequest req) throws DirectoryNotFoundException, OperationFailedException {
        EntityQuery<String> query = this.queryTransformer.groupNameQuery(req).getOrElseThrow(() -> new AtlassianUserRepositoryException(SpiError.UNSUPPORTED_FILTER, "Cannot handle group filter/attribute, please contact support and include the filter string"));
        java.util.List internalDirectoryGroups = this.directoryManager.searchGroups(this.directory.getId().longValue(), query);
        return this.paginate(internalDirectoryGroups, req);
    }

    public SearchResult<String> searchUsers(SearchRequest req) throws DirectoryNotFoundException, OperationFailedException {
        EntityQuery<String> query = this.queryTransformer.userNameQuery(req).getOrElseThrow(() -> new AtlassianUserRepositoryException(SpiError.UNSUPPORTED_FILTER, "SPI cannot handle this user filter, please contact support"));
        java.util.List userNames = this.directoryManager.searchUsers(this.directory.getId().longValue(), query);
        return this.paginate(userNames, req);
    }

    private <T> SearchResult<T> paginate(java.util.List<T> items, SearchRequest req) {
        int totalResults = items.size() + req.getStartIndex() - 1;
        if (this.isTooMany(totalResults)) {
            throw new AtlassianUserRepositoryException(SpiError.TOO_MANY_RESULTS, "Too many resources matching query");
        }
        List page = Stream.ofAll(items).take(req.getCount()).toList();
        return new SearchResult(page, req.getStartIndex(), totalResults);
    }

    private boolean isTooMany(int totalResults) {
        return false;
    }
}

