/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.atlassian.repository;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.ksso.scim.ScimLib;
import com.ksso.scim.filter.ScimFilterBaseVisitor;
import com.ksso.scim.filter.ScimFilterParser;
import com.ksso.scim.patch.PatchUtil;
import com.ksso.scim.schema.requests.SearchRequest;
import com.ksso.scim.util.StrUtil;
import io.prometheus.client.Counter;
import io.vavr.Tuple;
import io.vavr.Tuple3;
import io.vavr.control.Option;
import java.util.function.Function;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTransformer {
    private static final Logger log = LoggerFactory.getLogger(QueryTransformer.class);
    static final PropertyRestriction<String> SCIM_ID_NOT_NULL_RESTRICTION = Restriction.on((Property)PropertyUtils.ofTypeString((String)"ksso.scim.id")).startingWith((Object)"");

    public Option<EntityQuery<String>> userNameQuery(SearchRequest req) {
        return this.transform(req, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()), new UserTransformerVisitor());
    }

    public Option<EntityQuery<String>> groupNameQuery(SearchRequest req) {
        return this.transform(req, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()), new GroupTransformerVisitor());
    }

    private <T> Option<EntityQuery<T>> transform(SearchRequest req, QueryBuilder.PartialEntityQuery<T> partialBuilder, TransformerVisitor visitor) {
        int startIndex = req.getStartIndex() - 1;
        Option entityQuery = req.getFilter().peek(evaluator -> log.debug("Transforming query filter: {}", (Object)evaluator.getFilter())).map(evaluator -> evaluator.getFilterContext()).map(filterContext -> ((Option)visitor.visit((ParseTree)filterContext)).map(sr -> {
            SearchRestriction r = visitor.hasIdRestriction() ? sr : Combine.allOf((SearchRestriction[])new SearchRestriction[]{SCIM_ID_NOT_NULL_RESTRICTION, sr});
            return partialBuilder.with(r).startingAt(startIndex).returningAtMost(-1);
        })).getOrElse(() -> Option.of(partialBuilder.with(SCIM_ID_NOT_NULL_RESTRICTION).startingAt(startIndex).returningAtMost(-1)));
        boolean success = !entityQuery.isEmpty();
        ((Counter.Child)ScimLib.Metrics.filterTransformationsTotal.labels(String.valueOf(success))).inc();
        return entityQuery;
    }

    private static abstract class TransformerVisitor
    extends ScimFilterBaseVisitor<Option<? extends SearchRestriction>> {
        private boolean hasIdRestriction = false;

        private TransformerVisitor() {
        }

        Tuple3<String, String, String> unwrapArgs(ScimFilterParser.OperatorExprContext ctx) {
            String attrName = PatchUtil.toPathList(ctx.attrPath()).mkString(".");
            String operator = ctx.OPERATOR().getText();
            String criteria = StrUtil.unwrap(ctx.CRITERIA().getText(), "\"");
            return Tuple.of(attrName, operator, criteria);
        }

        @Override
        public Option<? extends SearchRestriction> visitOperatorExpr(ScimFilterParser.OperatorExprContext ctx) {
            Tuple3<String, String, String> args2 = this.unwrapArgs(ctx);
            if (StringUtils.equals("id", (CharSequence)args2._1)) {
                this.hasIdRestriction = true;
                return this.createPropertyRestriction(PropertyUtils.ofTypeString((String)"ksso.scim.id"), StringUtils.lowerCase((String)args2._2), args2._3);
            }
            return Option.none();
        }

        public boolean hasIdRestriction() {
            return this.hasIdRestriction;
        }

        @Override
        public Option<? extends SearchRestriction> visitFilter(ScimFilterParser.FilterContext ctx) {
            return (Option)super.visit(ctx.expr());
        }

        @Override
        public Option<? extends SearchRestriction> visitAndExpr(ScimFilterParser.AndExprContext ctx) {
            Option left = (Option)this.visit(ctx.expr(0));
            Option right = (Option)this.visit(ctx.expr(1));
            return left.map(l -> right.map(r -> Combine.allOf((SearchRestriction[])new SearchRestriction[]{l, r}))).flatMap(Function.identity());
        }

        @Override
        public Option<? extends SearchRestriction> visitOrExpr(ScimFilterParser.OrExprContext ctx) {
            Option left = (Option)this.visit(ctx.expr(0));
            Option right = (Option)this.visit(ctx.expr(1));
            return left.map(l -> right.map(r -> Combine.anyOf((SearchRestriction[])new SearchRestriction[]{l, r}))).flatMap(Function.identity());
        }

        @Override
        public Option<? extends SearchRestriction> visitPresentExpr(ScimFilterParser.PresentExprContext ctx) {
            return Option.none();
        }

        @Override
        public Option<? extends SearchRestriction> visitNotExpr(ScimFilterParser.NotExprContext ctx) {
            return Option.none();
        }

        @Override
        public Option<? extends SearchRestriction> visitAttrFilterExpr(ScimFilterParser.AttrFilterExprContext ctx) {
            return Option.none();
        }

        <V> Option<PropertyRestriction<V>> createPropertyRestriction(Property<V> property, String operator, V value) {
            Restriction.RestrictionWithProperty restriction = Restriction.on(property);
            if (StringUtils.equals("eq", operator)) {
                return Option.of(restriction.exactlyMatching(value));
            }
            return Option.none();
        }
    }

    private static class GroupTransformerVisitor
    extends TransformerVisitor {
        private GroupTransformerVisitor() {
        }

        @Override
        public Option<? extends SearchRestriction> visitOperatorExpr(ScimFilterParser.OperatorExprContext ctx) {
            Tuple3<String, String, String> args2 = this.unwrapArgs(ctx);
            if (StringUtils.equals("displayName", (CharSequence)args2._1)) {
                return this.createPropertyRestriction(GroupTermKeys.NAME, (String)args2._2, args2._3);
            }
            return super.visitOperatorExpr(ctx);
        }
    }

    private static class UserTransformerVisitor
    extends TransformerVisitor {
        private UserTransformerVisitor() {
        }

        @Override
        public Option<? extends SearchRestriction> visitOperatorExpr(ScimFilterParser.OperatorExprContext ctx) {
            Tuple3<String, String, String> args2 = this.unwrapArgs(ctx);
            if (StringUtils.equals("userName", (CharSequence)args2._1)) {
                return this.createPropertyRestriction(UserTermKeys.USERNAME, StringUtils.lowerCase((String)args2._2), args2._3);
            }
            if (StringUtils.equals(String.format("%s.%s.%s", "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", "manager", "value"), (CharSequence)args2._1)) {
                return this.createPropertyRestriction(PropertyUtils.ofTypeString((String)"ksso.scim.ue.managerId"), StringUtils.lowerCase((String)args2._2), args2._3);
            }
            if (StringUtils.equals("externalId", (CharSequence)args2._1)) {
                return this.createPropertyRestriction(PropertyUtils.ofTypeString((String)"ksso.scim.extId"), StringUtils.lowerCase((String)args2._2), args2._3);
            }
            return super.visitOperatorExpr(ctx);
        }
    }
}

