/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.atlassian.hostapp;

import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.sal.api.component.ComponentLocator;
import com.google.common.collect.ImmutableMap;
import com.ksso.scim.ScimProviderKind;
import com.ksso.scim.atlassian.hostapp.ScimHostApp;
import io.vavr.Tuple;
import io.vavr.collection.HashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Stream;
import io.vavr.control.Option;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class DefaultScimHostApp
implements ScimHostApp {
    public static final Set<OperationType> ALL_OPS = HashSet.of(OperationType.values()).toJavaSet();
    private final DirectoryManager directoryManager;
    private final ApplicationManager applicationManager;
    private final Application application;
    private final boolean usesDirectoryMapping;

    DefaultScimHostApp(DirectoryManager directoryManager, ApplicationManager applicationManager, boolean usesDirectoryMapping) {
        this.usesDirectoryMapping = usesDirectoryMapping;
        try {
            this.directoryManager = directoryManager;
            this.applicationManager = (ApplicationManager)ComponentLocator.getComponent(ApplicationManager.class);
            this.application = applicationManager.findByName("crowd-embedded");
        }
        catch (ApplicationNotFoundException e) {
            throw new RuntimeException("crowd-embedded not found", e);
        }
    }

    @Override
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Override
    public Map<String, Directory> findScimDirectories() {
        return Stream.ofAll(this.directoryManager.findAllDirectories()).filter(d -> d.getType() == DirectoryType.INTERNAL).map(d -> Tuple.of(d.getAttributes().get("ksso.scim.tenantId"), d)).filter(tuple -> tuple._1 != null).toMap(tuple -> (String)tuple._1, tuple -> (Directory)tuple._2);
    }

    @Override
    public Option<Directory> findDirectoryByTenantId(String tenantId) {
        return this.findScimDirectories().get(tenantId);
    }

    @Override
    public Directory addDirectory(String tenantId, String name, ScimProviderKind kind) {
        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder();
        builder.setType(DirectoryType.INTERNAL);
        builder.setName(name);
        builder.setImplementationClass(InternalDirectory.class.getName());
        ImmutableMap attrs = ImmutableMap.builder().put((Object)"useNestedGroups", (Object)"true").put((Object)"ksso.scim.tenantId", (Object)tenantId).put((Object)"user_encryption_method", (Object)"atlassian-security").put((Object)"ksso.scim.gen", (Object)"1").put((Object)"ksso.scim.kind", (Object)kind.name()).build();
        builder.setAttributes((java.util.Map)attrs);
        builder.setAllowedOperations(ALL_OPS);
        Directory directory = builder.toDirectory();
        try {
            Directory addedDirectory = this.directoryManager.addDirectory(directory);
            if (this.usesDirectoryMapping) {
                this.applicationManager.addDirectoryMapping(this.application, addedDirectory, true, ALL_OPS.toArray(new OperationType[0]));
            }
            return addedDirectory;
        }
        catch (ApplicationNotFoundException | DirectoryInstantiationException | DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeAllScimDirectories() {
        this.findScimDirectories().forEach((tenantId, directory) -> this.removeDirectory((Directory)directory));
    }

    @Override
    public void removeDirectoryById(long id) {
        try {
            Directory directory = this.directoryManager.findDirectoryById(id);
            if (!directory.getAttributes().containsKey("ksso.scim.tenantId")) {
                throw new RuntimeException("Directory " + directory.getName() + " can't be deleted: Not a SCIM directory");
            }
            this.removeDirectory(directory);
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException("Directory with id " + id + " not found", e);
        }
    }

    @Override
    public void removeDirectoryByTenantId(String tenantId) {
        this.findDirectoryByTenantId(tenantId).peek(this::removeDirectory);
    }

    @Override
    public void removeDirectory(Directory directory) {
        try {
            if (this.usesDirectoryMapping) {
                this.applicationManager.removeDirectoryFromApplication(directory, this.application);
            }
            this.directoryManager.removeDirectory(directory);
        }
        catch (DirectoryCurrentlySynchronisingException | DirectoryNotFoundException | ApplicationManagerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Directory resetAllowedOperations(Directory directory) {
        this.verifyInternal(directory);
        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)directory);
        builder.setAllowedOperations(ALL_OPS);
        Directory updated = builder.toDirectory();
        try {
            this.directoryManager.updateDirectory(updated);
            if (this.usesDirectoryMapping) {
                this.applicationManager.updateDirectoryMapping(this.application, updated, true, ALL_OPS);
            }
            return updated;
        }
        catch (ApplicationNotFoundException | DirectoryNotFoundException e) {
            throw new RuntimeException("Failed to set allowed operations", e);
        }
    }

    @Override
    public void setDirectoryName(Directory directory, String directoryName) {
        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)directory);
        builder.setName(directoryName);
        Directory updated = builder.toDirectory();
        try {
            this.directoryManager.updateDirectory(updated);
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException("Failed to update directory name", e);
        }
    }

    @Override
    public Directory findInternalDirectory() {
        List dirs = this.directoryManager.findAllDirectories();
        return (Directory)Stream.ofAll(dirs).filter(dir -> dir.getType() == DirectoryType.INTERNAL).filter(dir -> StringUtils.containsIgnoreCase(dir.getName(), "Internal Directory")).get();
    }

    private void verifyInternal(Directory directory) {
        if (directory.getType() != DirectoryType.INTERNAL) {
            throw new IllegalArgumentException("Directory is not internal: " + directory);
        }
    }
}

