/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim.atlassian.auth;

import com.ksso.scim.atlassian.auth.AuthUtils;
import io.vavr.control.Option;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class ApplicationSecret {
    private final String salt;
    private final String hashed;
    private final AtomicReference<String> validationCache = new AtomicReference();

    private ApplicationSecret(String salt, String hashValue) {
        this.salt = Objects.requireNonNull(salt);
        this.hashed = Objects.requireNonNull(hashValue);
    }

    public static ApplicationSecret create(String salt, String hashedValue) {
        return new ApplicationSecret(salt, hashedValue);
    }

    public static ApplicationSecret createHash(String salt, String plainTextValue) {
        String hash = AuthUtils.hash(salt, plainTextValue);
        return new ApplicationSecret(salt, hash);
    }

    public String getSalt() {
        return this.salt;
    }

    public String getHashed() {
        return this.hashed;
    }

    public boolean validateSecret(String secret) {
        return Option.of(secret).map(this::validateHash).getOrElse(false);
    }

    boolean validateHash(String token) {
        String cachedPlainText = this.validationCache.get();
        if (cachedPlainText != null) {
            return cachedPlainText.equals(token);
        }
        String hash = AuthUtils.hash(this.salt, token);
        boolean equals = this.hashed.equals(hash);
        if (equals) {
            this.validationCache.set(token);
        }
        return equals;
    }

    public String toString() {
        return "ApplicationSecret{salt='" + this.salt + '\'' + ", applicationSecretHashed='" + this.hashed + '\'' + '}';
    }
}

