/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim;

import java.util.function.Supplier;

public enum ScimVersion {
    V1_1("v1"),
    V2_0("v2");

    private final String pathValue;

    private ScimVersion(String pathValue) {
        this.pathValue = pathValue;
    }

    public String pathValue() {
        return this.pathValue;
    }

    public <T> T fold(Supplier<T> onV1, Supplier<T> onV2) {
        return this == V1_1 ? onV1.get() : onV2.get();
    }

    public static ScimVersion fromString(String value) {
        if ("v1".equals(value)) {
            return V1_1;
        }
        if ("v2".equals(value)) {
            return V2_0;
        }
        throw new IllegalArgumentException("Invalid SCIM version '" + value + "'");
    }
}

