/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim;

import com.atlassian.json.jsonorg.JSONObject;
import com.ksso.scim.ScimResponse;
import com.ksso.scim.ScimResponseCode;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScimResponseWriter {
    private static final Logger log = LoggerFactory.getLogger(ScimResponseWriter.class);
    private final HttpServletResponse response;

    public ScimResponseWriter(HttpServletResponse response) {
        this.response = response;
    }

    private void write(ScimResponseCode status, Option<JSONObject> body, Map<String, List<String>> responseHeaders) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("<<< {} {}: {}", new Object[]{status.intValue(), status.name(), body.map(JSONObject::toString).getOrElse("<empty body>")});
        }
        responseHeaders.forEach((name, values2) -> values2.forEach(value -> this.response.addHeader(name, value)));
        this.response.setStatus(status.intValue());
        if (body.isDefined()) {
            body.get().write(this.response.getWriter());
        }
    }

    public void write(ScimResponse scimResponse) throws IOException {
        this.write(scimResponse.getStatus(), scimResponse.getResponseJson(), scimResponse.getResponseHeaders());
    }
}

