/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim;

import com.ksso.scim.ScimVersion;
import io.vavr.Tuple;
import io.vavr.collection.Iterator;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import org.apache.commons.lang3.StringUtils;

public enum ScimResource {
    USERS("Users"){

        @Override
        public String typeString() {
            return "User";
        }
    }
    ,
    GROUPS("Groups"){

        @Override
        public String typeString() {
            return "Group";
        }
    }
    ,
    SCHEMAS("Schemas"),
    BULK("Bulk"),
    ME("Me"),
    SERVICE_PROVIDER_CONFIG("ServiceProviderConfig"){

        @Override
        public String endpointValue(ScimVersion v) {
            return v.fold(() -> "ServiceProviderConfigs", () -> this.endpointValue);
        }
    }
    ,
    RESOURCE_TYPES("ResourceTypes");

    private static final Map<String, ScimResource> ENDPOINT_VALUE_INDEX;
    final String endpointValue;

    private ScimResource(String endpointValue) {
        this.endpointValue = endpointValue;
    }

    public String endpointValue(ScimVersion v) {
        return this.endpointValue;
    }

    public String typeString() {
        return this.endpointValue;
    }

    public static Option<ScimResource> fromTypeString(String type) {
        if (StringUtils.equalsIgnoreCase(type, "user")) {
            return Option.of(USERS);
        }
        if (StringUtils.equalsIgnoreCase(type, "group")) {
            return Option.of(GROUPS);
        }
        return Option.none();
    }

    public static ScimResource fromEndpointValue(String resource) {
        return ENDPOINT_VALUE_INDEX.get(resource).getOrElseThrow(() -> new IllegalArgumentException("'" + resource + "' it not a valid endpoint value"));
    }

    static {
        ENDPOINT_VALUE_INDEX = Iterator.of(ScimResource.values()).toStream().crossProduct(Iterator.of(ScimVersion.values())).map(cpTuple -> cpTuple.map((resource, version) -> Tuple.of(resource.endpointValue((ScimVersion)((Object)((Object)version))), resource))).toMap(tup -> (String)tup._1, tup -> (ScimResource)((Object)((Object)tup._2)));
    }
}

