/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim;

import com.atlassian.json.jsonorg.JSONObject;
import com.google.common.base.Charsets;
import com.ksso.scim.HttpRequestInfo;
import com.ksso.scim.ScimRequest;
import com.ksso.scim.ScimResource;
import com.ksso.scim.ScimVersion;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScimRequestReader {
    private static final Logger log = LoggerFactory.getLogger(ScimRequestReader.class);
    private static final int MAX_PAYLOAD_LIMIT = 0x400000;
    private final HttpServletRequest req;

    public ScimRequestReader(HttpServletRequest req) {
        this.req = req;
    }

    public Either<String, ScimRequest> parseRequest() throws IOException {
        HttpRequestInfo requestInfo = new HttpRequestInfo(this.req);
        log.debug(">>> {} {}, parameterMap:({}), headerMap:({})", new Object[]{requestInfo.getMethod(), requestInfo.getRequestURI(), requestInfo.getParameterMap(), requestInfo.getHeaderMap()});
        String[] parts = StringUtils.split(requestInfo.getInternalRequestURI(), "/");
        if (parts == null || parts.length < 3) {
            log.warn("Bad request URI: {}", (Object)this.req.getRequestURI());
            return Either.left("Bad request URI: " + this.req.getRequestURI());
        }
        String tenantId = parts[0];
        ScimVersion scimVersion = ScimVersion.fromString(parts[1]);
        ScimResource scimResource = ScimResource.fromEndpointValue(parts[2]);
        Option<String> resourceId = parts.length > 3 ? Option.of(parts[3]) : Option.none();
        Option<JSONObject> jsonBody = ScimRequestReader.parseJsonBody(this.req);
        ScimRequest scimRequest = new ScimRequest(scimVersion, tenantId, scimResource, resourceId, requestInfo, jsonBody);
        return Either.right(scimRequest);
    }

    private static Option<JSONObject> parseJsonBody(HttpServletRequest request) throws IOException {
        if (request.getContentLength() > 0x400000) {
            throw new IOException("Content-length " + request.getContentLength() + " exceeds maximum payload limit: " + 0x400000);
        }
        BoundedInputStream boundedInputStream = new BoundedInputStream((InputStream)request.getInputStream(), 0x400000L);
        String encoding = Option.of(request.getCharacterEncoding()).getOrElse(Charsets.ISO_8859_1.displayName());
        return Option.of(IOUtils.toString((InputStream)boundedInputStream, (String)encoding)).filter(StringUtils::isNotBlank).peek(body -> log.debug("Request body: {}", body)).map(body -> Try.of(() -> new JSONObject((String)body)).onFailure(t -> log.warn("Ignoring invalid JSON request body: {}", (Object)t.getMessage())).toOption()).flatMap(o -> o);
    }
}

