/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim;

import com.atlassian.json.jsonorg.JSONObject;
import com.ksso.scim.HttpMethod;
import com.ksso.scim.HttpRequestInfo;
import com.ksso.scim.ScimHeaders;
import com.ksso.scim.ScimQueryParams;
import com.ksso.scim.ScimResource;
import com.ksso.scim.ScimVersion;
import io.vavr.control.Option;

public class ScimRequest {
    private final ScimResource resource;
    private final ScimVersion scimVersion;
    private final Option<String> resourceId;
    private final String tenantId;
    private final HttpRequestInfo requestInfo;
    private final Option<JSONObject> jsonBody;
    private final long ts;

    public ScimRequest(ScimVersion scimVersion, String tenantId, ScimResource resource, Option<String> resourceId, HttpRequestInfo requestInfo, Option<JSONObject> jsonBody) {
        this.scimVersion = scimVersion;
        this.tenantId = tenantId;
        this.resource = resource;
        this.resourceId = resourceId;
        this.requestInfo = requestInfo;
        this.jsonBody = jsonBody;
        this.ts = System.nanoTime();
    }

    public ScimVersion getScimVersion() {
        return this.scimVersion;
    }

    public Option<JSONObject> getJsonBody() {
        return this.jsonBody;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public Option<String> getResourceId() {
        return this.resourceId;
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.requestInfo.getMethod());
    }

    public ScimResource getResource() {
        return this.resource;
    }

    public String getRequestURI() {
        return this.requestInfo.getRequestURI();
    }

    public ScimQueryParams getQueryParams() {
        return new ScimQueryParams(this.requestInfo.getParameterMap());
    }

    public ScimHeaders getScimHeaders() {
        return new ScimHeaders(this.requestInfo.getHeaderMap());
    }

    public HttpRequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public long getTs() {
        return this.ts;
    }

    public String toString() {
        return "ScimRequest{resource=" + (Object)((Object)this.resource) + ", scimVersion=" + (Object)((Object)this.scimVersion) + ", resourceId=" + this.resourceId + ", tenantId='" + this.tenantId + '\'' + ", requestInfo=" + this.requestInfo + ", jsonBody=" + this.jsonBody + '}';
    }
}

