/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim;

import com.ksso.scim.ScimRequest;
import com.ksso.scim.ScimResource;
import com.ksso.scim.ScimVersion;

public class MetaUrlBuilder {
    private final String baseUrl;
    private final String servletBase;
    private final String tenantId;
    private final ScimVersion version;

    private MetaUrlBuilder(String baseUrl, String servletBase, String tenantId, ScimVersion version) {
        this.baseUrl = baseUrl;
        this.servletBase = servletBase;
        this.tenantId = tenantId;
        this.version = version;
    }

    public String url(ScimResource resource, String resourceId) {
        return String.format("%s/%s", this.url(resource), resourceId);
    }

    public String url(ScimResource resource) {
        return String.format("%s%s/%s/%s/%s", this.baseUrl, this.servletBase, this.tenantId, this.version.pathValue(), resource.endpointValue(this.version));
    }

    public static MetaUrlBuilder fromRequest(ScimRequest request) {
        String hostname = MetaUrlBuilder.getHostname(request);
        String scheme = MetaUrlBuilder.getScheme(request);
        int port = MetaUrlBuilder.getPort(request);
        String portString = port == 443 || port == 80 ? "" : String.format(":%d", port);
        String baseUrl = scheme + "://" + hostname + portString;
        String scimServletBase = request.getRequestInfo().getServletBase();
        return new MetaUrlBuilder(baseUrl, scimServletBase, request.getTenantId(), request.getScimVersion());
    }

    private static int getPort(ScimRequest request) {
        return request.getScimHeaders().getXForwardedPort().map(Integer::valueOf).getOrElse(request.getRequestInfo().getServerPort());
    }

    private static String getScheme(ScimRequest request) {
        return request.getScimHeaders().getXForwardedProto().getOrElse(request.getRequestInfo().getScheme());
    }

    private static String getHostname(ScimRequest request) {
        return request.getScimHeaders().getXForwardedHost().getOrElse(request.getRequestInfo().getServerName());
    }
}

