/*
 * Decompiled with CFR 0.152.
 */
package com.ksso.scim;

import com.ksso.scim.util.ServletUtil;
import io.vavr.collection.List;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class HttpRequestInfo {
    private static final String SCIM_SERVICE_PATH_MARKER = "/scim/";
    private final String method;
    private final String scheme;
    private final int serverPort;
    private final String requestURI;
    private final String internalRequestURI;
    private final Map<String, List<String>> headerMap;
    private final Map<String, List<String>> parameterMap;
    private final String serverName;
    private final String servletBase;
    private final Option<String> queryString;

    public HttpRequestInfo(HttpServletRequest req) {
        this.method = req.getMethod();
        this.scheme = req.getScheme();
        this.requestURI = req.getRequestURI();
        this.queryString = Option.of(req.getQueryString());
        this.serverPort = req.getServerPort();
        this.serverName = req.getServerName();
        this.headerMap = ServletUtil.getHeaderMap(req);
        this.parameterMap = ServletUtil.getParameterMap(req);
        int idx = StringUtils.lastIndexOf((CharSequence)this.requestURI, SCIM_SERVICE_PATH_MARKER) + SCIM_SERVICE_PATH_MARKER.length() - 1;
        this.internalRequestURI = StringUtils.substring(this.requestURI, idx, this.requestURI.length());
        this.servletBase = StringUtils.substring(this.requestURI, 0, idx);
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public Option<String> getQueryString() {
        return this.queryString;
    }

    public Map<String, List<String>> getHeaderMap() {
        return this.headerMap;
    }

    public Map<String, List<String>> getParameterMap() {
        return this.parameterMap;
    }

    public String getInternalRequestURI() {
        return this.internalRequestURI;
    }

    public String getServletBase() {
        return this.servletBase;
    }

    public String getMethod() {
        return this.method;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getServerName() {
        return this.serverName;
    }
}

