/*
 * Decompiled with CFR 0.152.
 */
package com.kantegasso.jsonmapping;

import com.kantegasso.jsonmapping.JsonMapping;
import io.vavr.collection.List;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;

class Utils {
    static final int MAX_RECURSION_DEPTH = 10;
    static final Map<Class<?>, Class<?>> primitiveTypeConversion = new HashMap();

    Utils() {
    }

    static String asField(String methodName) {
        List<String> possiblePrefixes = List.of("is", "get", "set");
        String methodPrefix = (String)possiblePrefixes.filter(methodName::startsWith).get();
        String fieldName = methodName.replaceFirst(methodPrefix, "");
        return String.format("%s%s", Character.valueOf(Character.toLowerCase(fieldName.charAt(0))), fieldName.substring(1));
    }

    static boolean isMethodAccessor(Method method) {
        return Try.of(() -> method.getName().startsWith("get") || method.getName().startsWith("is")).getOrElse(false);
    }

    static Class<?> convertPrimitiveType(Class<?> type) {
        return Try.of(() -> type.isPrimitive() ? primitiveTypeConversion.get(type) : type).getOrElse(type);
    }

    static boolean isJavaLangNumber(Class<?> type) {
        return Try.of(() -> Utils.convertPrimitiveType(type)).mapTry(objectType -> objectType.getSuperclass().equals(Number.class)).getOrElse(false);
    }

    static boolean isTypeEquals(Class<?> type1, Class<?> type2) {
        return Utils.convertPrimitiveType(type1).equals(Utils.convertPrimitiveType(type2));
    }

    static boolean isBasicJavaObject(Object value) {
        return Utils.isBasicJavaObject(value.getClass());
    }

    static boolean isBasicJavaObject(Class<?> type) {
        return type.isPrimitive() || type.getPackage().getName().startsWith("java") || type.isEnum();
    }

    static Object convertJavaLangNumber(Object value, Class<?> valueType, Class<?> typeToConvert) throws IllegalAccessException, InvocationTargetException {
        Method valueConversionMethod = (Method)List.of(valueType.getMethods()).filter(method -> Utils.isTypeEquals(typeToConvert, method.getReturnType())).filter(method -> method.getName().endsWith("Value")).get();
        return valueConversionMethod.invoke(value, new Object[0]);
    }

    static boolean isTypeApplicableToParse(Class<?> typeTo, Class<?> typeFrom) {
        return Utils.isTypeEquals(typeFrom, typeTo) || Utils.isJavaLangNumber(typeFrom) && Utils.isJavaLangNumber(typeTo) || typeFrom.equals(String.class) && typeTo.isEnum() || typeFrom.equals(HashMap.class) && !Utils.isBasicJavaObject(typeTo);
    }

    static String parseFieldName(Field field) {
        return Option.of(field.getAnnotation(JsonMapping.JsonProperty.class)).map(JsonMapping.JsonProperty::value).filter(value -> !value.isEmpty()).getOrElse(field.getName());
    }

    static void makeFieldModifiable(Field field) {
        AccessController.doPrivileged(() -> {
            try {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                Utils.makeFieldAccessible(field);
                Utils.makeFieldAccessible(modifiersField);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            return null;
        });
    }

    static void makeFieldAccessible(Field field) {
        AccessController.doPrivileged(() -> {
            try {
                field.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return null;
        });
    }

    static Map<String, String> convertToStringValues(Map<String, ?> map) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        map.forEach((key, value) -> newMap.put((String)key, String.valueOf(value)));
        return newMap;
    }

    static <T> Try<T> invokePrivateConstuctor(Class<T> valueType) {
        return Try.of(() -> ((Constructor)List.of(valueType.getDeclaredConstructors()).filter(constructor -> constructor.getParameterCount() == 0).map(constructor -> {
            constructor.setAccessible(true);
            return constructor;
        }).get()).newInstance(new Object[0])).mapTry(valueType::cast);
    }

    static String parseFieldName(Method method) {
        return Option.of(method.getAnnotation(JsonMapping.JsonProperty.class)).map(JsonMapping.JsonProperty::value).filter(value -> !value.isEmpty()).getOrElse(Utils.asField(method.getName()));
    }

    static {
        primitiveTypeConversion.put(Boolean.TYPE, Boolean.class);
        primitiveTypeConversion.put(Byte.TYPE, Byte.class);
        primitiveTypeConversion.put(Short.TYPE, Short.class);
        primitiveTypeConversion.put(Character.TYPE, Character.class);
        primitiveTypeConversion.put(Integer.TYPE, Integer.class);
        primitiveTypeConversion.put(Long.TYPE, Long.class);
        primitiveTypeConversion.put(Float.TYPE, Float.class);
        primitiveTypeConversion.put(Double.TYPE, Double.class);
    }
}

