/*
 * Decompiled with CFR 0.152.
 */
package com.kantegasso.jsonmapping;

import com.kantegasso.jsonmapping.JsonMapping;
import com.kantegasso.jsonmapping.Utils;
import com.kantegasso.jsonmapping.error.JsonMappingException;
import io.vavr.collection.LinearSeq;
import io.vavr.collection.List;
import io.vavr.collection.Traversable;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

class Core {
    Core() {
    }

    static class Read {
        Read() {
        }

        static <T> Try<T> valueFromJson(JSONObject jsonObject, Class<T> valueType) {
            return Try.of(() -> valueType).filterTry(type -> type.getDeclaredAnnotation(JsonMapping.JsonMapper.class) != null, () -> new JsonMappingException("JSON-KFSVGVSYHL", "The type '" + Try.of(valueType::getName).getOrElse("") + "' does not have the required annotation @JsonMapper.")).flatMapTry(_type -> Read.valueFromJson(jsonObject, valueType, 0));
        }

        private static <T> Try<T> valueFromJson(JSONObject jsonObject, Class<T> valueType, int recursionDepth) {
            return Read.parseObjectWithConstructor(jsonObject, valueType, recursionDepth).orElse(Read.parseMutableObjectWithSetters(jsonObject, valueType, recursionDepth)).orElse(Read.parseObjectWithFields(jsonObject, valueType, recursionDepth));
        }

        static <T> Try<Void> populateInstanceFromJson(JSONObject jsonObject, T object, Class<?> valueType) {
            return Read.populateInstanceFromJson(jsonObject, object, valueType, 0);
        }

        private static <T> Try<Void> populateInstanceFromJson(JSONObject jsonObject, T object, Class<?> valueType, int recursionDepth) {
            return Try.of(() -> valueType).filterTry(type -> type.getDeclaredAnnotation(JsonMapping.JsonMapper.class) != null, () -> new JsonMappingException("JSON-Z4R10OE60N", "The type '" + Try.of(valueType::getName).getOrElse("") + "' does not have the required annotation @JsonMapper.")).mapTry(type -> List.of(type.getDeclaredMethods()).filter(method -> method.getName().startsWith("set")).filter(method -> method.getParameterCount() == 1).filter(method -> method.getReturnType().equals(Void.TYPE)).map(setter -> Read.setValueFromJson(object, setter, jsonObject, recursionDepth))).filterTry(Traversable::nonEmpty).filterTry(tryList -> tryList.forAll(Try::isSuccess)).filterTry(list -> recursionDepth < 10).flatMapTry(Traversable::get);
        }

        private static <T> Try<Void> setValueFromJson(T object, Method setter, JSONObject jsonObject, int recursionDepth) {
            return Try.of(() -> {
                Map<String, Object> jsonMap = jsonObject.toMap();
                String fieldName = Utils.parseFieldName(setter);
                return jsonMap.get(fieldName);
            }).flatMapTry(valueFromJson -> Try.run(() -> {
                Class<?> setterType = setter.getParameterTypes()[0];
                Object parsedValue = Read.parseValue(setterType, valueFromJson, recursionDepth);
                setter.invoke(object, parsedValue);
            }).orElse(Try.run(() -> {
                if (valueFromJson == null) {
                    setter.invoke(object, new Object[]{null});
                }
            })));
        }

        private static <T> Try<T> parseMutableObjectWithSetters(JSONObject jsonObject, Class<T> valueType, int recursionDepth) {
            return Try.of(valueType::newInstance).filterTry(object -> recursionDepth < 10).mapTry(object -> {
                Read.populateInstanceFromJson(jsonObject, object, valueType, recursionDepth).getOrElseThrow(throwable -> new JsonMappingException("JSON-8C8T0SOFH8", "Could not parse mutable object. ", (Throwable)throwable));
                return object;
            });
        }

        private static <T> Try<T> parseObjectWithConstructor(JSONObject jsonObject, Class<T> valueType, int recursionDepth) {
            return Try.of(() -> {
                LinearSeq fieldTypes = List.of(valueType.getDeclaredFields()).filter(field -> !field.getName().startsWith("this$")).map(Field::getType);
                return (Constructor)List.of(valueType.getConstructors()).filter(arg_0 -> Read.lambda$null$15((List)fieldTypes, arg_0)).get();
            }).mapTry(constructor -> {
                constructor.setAccessible(true);
                return constructor;
            }).filterTry(constructor -> recursionDepth < 10).mapTry(constructor -> constructor.newInstance(Read.sortParameters(jsonObject, constructor, recursionDepth))).mapTry(valueType::cast);
        }

        private static Object[] sortParameters(JSONObject jsonObject, Constructor<?> constructor, int recursionDepth) {
            Map<String, Object> jsonMap = jsonObject.toMap();
            List<Parameter> parameters = List.of(constructor.getParameters());
            return parameters.map(parameter -> {
                Class<?> parameterType = Utils.convertPrimitiveType(parameter.getType());
                String parameterName = Option.of(parameter.getAnnotation(JsonMapping.JsonProperty.class)).map(JsonMapping.JsonProperty::value).filter(value -> !value.isEmpty()).getOrElseThrow(() -> new JsonMappingException("JSON-CBVT9U637O", "JsonProperty annotation in constructor required to construct immutable Java object from json."));
                Object parameterValue = List.ofAll(jsonMap.keySet()).find(jsonKey -> {
                    Class<?> jsonFieldType = jsonMap.get(jsonKey).getClass();
                    return Utils.isTypeApplicableToParse(parameterType, jsonFieldType) && jsonKey.equals(parameterName);
                }).map(jsonMap::get).map(value -> Read.parseValue(parameterType, value, recursionDepth)).getOrNull();
                return parameterValue;
            }).toJavaArray();
        }

        private static Object parseValue(Class<?> parameterType, Object value, int recursionDepth) {
            return Try.of(() -> {
                Class<?> valueType = Utils.convertPrimitiveType(value.getClass());
                if (Utils.isTypeEquals(valueType, parameterType)) {
                    return value;
                }
                if (parameterType.isEnum() && value instanceof String) {
                    return Try.of(() -> parameterType.getDeclaredMethod("valueOf", String.class).invoke(null, value)).getOrElse(value);
                }
                if (Utils.isJavaLangNumber(parameterType) && Utils.isJavaLangNumber(valueType)) {
                    return Try.of(() -> Utils.convertJavaLangNumber(value, valueType, parameterType)).getOrElse(value);
                }
                if (value instanceof HashMap) {
                    return JsonMapping.Write.mapAsJson((HashMap)value).flatMapTry(json -> Read.valueFromJson(json, parameterType, recursionDepth + 1)).getOrElseThrow(() -> new JsonMappingException("JSON-A62Z4DGS1R", "Could not parse nested JSON"));
                }
                return value;
            }).getOrElse(value);
        }

        private static <T> Try<T> parseObjectWithFields(JSONObject jsonObject, Class<T> valueType, int recursionDepth) {
            return Try.of(() -> valueType.newInstance()).filterTry(_instance -> recursionDepth < 10).recoverWith(IllegalAccessException.class, Utils.invokePrivateConstuctor(valueType)).mapTry(instance -> {
                List.of(valueType.getDeclaredFields()).forEach(field -> {
                    String fieldName = Utils.parseFieldName(field);
                    Object valueFromJson = jsonObject.get(fieldName);
                    try {
                        Utils.makeFieldModifiable(field);
                        Class<?> fieldType = Utils.convertPrimitiveType(field.getType());
                        Object parsedValue = Read.parseValue(fieldType, valueFromJson, recursionDepth);
                        field.set(instance, parsedValue);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                return instance;
            });
        }

        private static /* synthetic */ boolean lambda$null$15(List fieldTypes, Constructor constructor) {
            return List.of(constructor.getParameterTypes()).containsAll(fieldTypes);
        }
    }

    static class Write {
        Write() {
        }

        static <T> Try<JSONObject> objectAsJson(T object, Class<?> valueType) {
            return Write.objectAsJson(object, valueType, 0);
        }

        static <T> Try<JSONObject> objectAsJson(T object) {
            return Write.objectAsJson(object, object.getClass(), 0);
        }

        static <T> Try<JSONObject> objectAsJson(T object, Class<?> valueType, int recursionDepth) {
            return Write.writeJsonFromAccessors(object, valueType, recursionDepth).orElse(Write.writeJsonFromFields(object, recursionDepth));
        }

        static <T> Try<JSONObject> writeJsonFromFields(T object, int recursionDepth) {
            return Try.of(() -> object.getClass().getDeclaredFields()).mapTry(List::of).filterTry(fields -> !fields.isEmpty(), () -> new JsonMappingException("JSON-0ZNRDWGTO7", "Instance has no fields")).filterTry(fields -> recursionDepth < 10).filterTry(_fields -> object.getClass().getDeclaredAnnotation(JsonMapping.JsonMapper.class) != null, () -> new JsonMappingException("JSON-LK5AWB99NQ", "The type '" + Try.of(() -> object.getClass().getName()).getOrElse("") + "' does not have the required annotation @JsonMapper.")).mapTry(fields -> {
                JSONObject jsonObject = new JSONObject();
                fields.forEach(field -> {
                    String fieldName = Utils.parseFieldName(field);
                    Try.of(() -> {
                        Utils.makeFieldAccessible(field);
                        return field.get(object);
                    }).mapTry(value -> {
                        if (Utils.isBasicJavaObject(value)) {
                            return value;
                        }
                        return Write.objectAsJson(value, value.getClass(), recursionDepth + 1).getOrElseThrow(() -> new RuntimeException("Failed to write json nested"));
                    }).mapTry(value -> jsonObject.put(fieldName, value));
                });
                return jsonObject;
            }).filterTry(json -> !json.isEmpty());
        }

        static <T> Try<JSONObject> writeJsonFromAccessors(T object, Class<?> valueType, int recursionDepth) {
            return Try.of(() -> valueType).filterTry(_type -> recursionDepth < 10).filterTry(type -> valueType.getDeclaredAnnotation(JsonMapping.JsonMapper.class) != null, () -> new JsonMappingException("JSON-5COOZK00Z8", "The type '" + Try.of(() -> object.getClass().getName()).getOrElse("") + "' does not have the required annotation @JsonMapper.")).mapTry(type -> {
                JSONObject jsonObject = new JSONObject();
                List.of(type.getDeclaredMethods()).filter(Utils::isMethodAccessor).filter(accessor -> accessor.getAnnotation(JsonMapping.JsonProperty.class) != null).forEach(accessor -> {
                    String fieldName = Utils.parseFieldName(accessor);
                    Try.of(() -> accessor.invoke(object, (Object[])null)).mapTry(value -> {
                        if (Utils.isBasicJavaObject(value)) {
                            return value;
                        }
                        return Write.objectAsJson(value, value.getClass(), recursionDepth + 1);
                    }).mapTry(value -> jsonObject.put(fieldName, value));
                });
                return jsonObject;
            }).filterTry(json -> !json.isEmpty());
        }
    }
}

