console.log("Defining samlInstallUsernameHook");

window.samlInstallUsernameHook = function (hookOptions) {
  window.addEventListener("load", function () {
    console.trace("Page loaded, installing SAML username hook");

    var loginContainer = document.querySelector("#login-container");

    var usernameInput = document.querySelector(
        "input[name=os_username], input[name=j_username], input[name=username]"
    );

    var linkClicked = false;

    function setup() {
      loginContainer = document.querySelector("#login-container");

      usernameInput = document.querySelector(
          "input[name=os_username], input[name=j_username], input[name=username]"
      );

      if (!usernameInput) {
        console.log("Usernameinput not found, bailing out");
        return;
      }

      if (usernameInput.samlComplete) {
        console.log("Usernameinput already completed, bailing out");
        return;
      }
      // Username / password error (CAPTCHA, etc)
      if (usernameInput.form.parentNode.querySelector(".aui-message.error")) {
        console.log("Login form has error message, bailing out");
        return;
      }

      var username_password_disabled_text = document.querySelector(
          "#username_password_disabled_text"
      );
      if (username_password_disabled_text) {
        username_password_disabled_text.style.display = "none";
      }

      var passwordInput = document.querySelector(
          "input[name=os_password], input[name=j_password], input[name=password]"
      );
      var loginform = usernameInput.form;

      var loginMainButton;

      var workAccountInput;

      var workAccountForm;
      var workAccountSection;

      var workAccountList;
      var workAccountSelection;

      var idpOrgName;
      var redirInd;
      var start;
      var redirectProgressDelay = 2000;
      var autoRedirect;
      var currentRedirect;
      var enterCount = 0;

      var target;

      var finding = false;

      var windowBlurred = false;

      var dropdownOpen = false;

      var visibleProviders = [];

      function findProviders(username, options) {
        if (username.trim().length === 0) {
          return;
        }
        if (autoRedirect) {
          console.log("Already redirecting");
          return;
        }
        if (finding) {
          console.log("Already finding");
          return;
        }
        if (windowBlurred) {
          return;
        }
        finding = true;

        loginMainButton.setAttribute("disabled", "disabled");

        AJS.$(".use-up-link-container").addClass("hidden");

        var xhr = new XMLHttpRequest();
        xhr.onreadystatechange = function () {
          if (xhr.readyState === 4) {

            finding = false;
            clearErrors();
            if (windowBlurred) {
              return;
            }
            if (xhr.status === 200) {
              console.log("findProviders(): callback");

              var data = JSON.parse(xhr.responseText);
              var matches = data.matches;

              if (data.isSystemAdmin) {
                AJS.$(".use-up-link-container").removeClass("hidden");
              }

              if (matches.length === 0) {
                if (options.fallbackRedirection) {
                  if (!data.fallbacks || data.fallbacks.length === 0) {
                    usernameInput.value = username;
                    enterUsernamePassword();
                    passwordInput.focus();
                  } else if (data.fallbacks) {
                    AJS.$(".use-up-link-container").removeClass("hidden");
                    if (data.fallbacks.length === 1) {
                      redirectTo(data.fallbacks[0]);
                    } else {
                      showProviderSelectionList(data.fallbacks);
                    }
                  }
                } else {
                  showProviderSelectionList([]);
                }
              } else if (matches.length === 1) {
                console.log("findProviders callback: Redirect to matching idp: " +
                    matches[0].name + " sendLoginHint: " +
                    matches[0].sendLoginHint);
                var encodedUsername = encodeURIComponent(username);
                if (matches[0].sendLoginHint === "true" && encodedUsername) {
                  console.log("Adding login_hint: " + encodedUsername);
                  matches[0].loginUrl += "?username=" + encodedUsername
                      + "&login_hint=" + encodedUsername;
                }
                redirectTo(matches[0]);
              } else {
                showProviderSelectionList(matches);
              }
              resizeContainer();
            }
          }
        };
        xhr.open(
            "POST",
            findContextPath() + "/plugins/servlet/no.kantega.saml/discover"
        );
        xhr.setRequestHeader(
            "Content-Type",
            "application/x-www-form-urlencoded"
        );
        xhr.send("username=" + encodeURIComponent(username));
      }

      function showProviderSelectionList(providers) {
        providers.sort(function (a, b) {
          return a.name.localeCompare(b.name);
        });

        while (workAccountList.firstChild) {
          workAccountList.removeChild(workAccountList.firstChild);
        }

        var list = providers.concat(visibleProviders);
        var keys = {};
        var merged = [];
        for (var i = 0; i < list.length; i++) {
          var idp = list[i];
          if (!keys.hasOwnProperty(idp.id)) {
            keys[idp.id] = idp;
            merged.push(idp);
          }
        }

        for (var i = 0; i < merged.length; i++) {
          var idp = merged[i];
          workAccountList.appendChild(createProvider(idp));
        }
        if (merged.length > 0) {
          AJS.$(workAccountSelection).removeClass("hidden");
        } else {
          AJS.$(workAccountSelection).addClass("hidden");
        }
        resizeContainer();
      }

      function isAbsolute(target) {
        var tlc = target.toLowerCase();
        return tlc.indexOf("https://") === 0 || tlc.indexOf("http://") === 0;
      }

      function findContextPath() {
        if (AJS.contextPath) {
          return AJS.contextPath();
        }
        return window.contextPath;
      }

      function resizeContainer() {
        if (loginContainer && loginContainer.parentNode.style.height) {
          loginContainer.parentNode.style.height =
              loginContainer.offsetHeight + "px";
          if (window.gadgets) {
            window.gadgets.rpc.call(null, "resize_iframe", null, height);
          }
        } else if ("gadgets" in window) {
          var height = usernameInput.form.parentNode.offsetHeight + 20;
          if (dropdownOpen) {
            height += document.querySelector("#loginMethodDropdown")
                .offsetHeight;
          }
          gadgets.rpc.call(null, "resize_iframe", null, height);
        } else {
          console.log("No resize");
        }
      }

      function redirect(url) {
        url = addTargetParameter(url);
        console.log("Url after addTarget: ", url);
        window.top.location.href = url;
      }

      function addTargetParameter(url) {
        var output = url;
        if (target) {
          if (url.indexOf("?") !== -1) {
            output += "&";
          } else {
            output += "?";
          }
          output += "target=" + encodeURIComponent(target);
        }

        return output;
      }

      function cancelRedirect() {
        autoRedirect = clearInterval(autoRedirect);
        workAccountInput.removeAttribute("disabled");
        workAccountInput.focus();
        loginMainButton.removeAttribute("disabled");
        AJS.$(redirInd).addClass("hidden");
        showProviderSelectionList([currentRedirect]);
        resizeContainer();
      }

      function redirectTo(provider) {
        AJS.$(workAccountSelection).addClass("hidden");

        var name = provider.name;
        var url = provider.loginUrl;

        if (autoRedirect) {
          console.log("Already redirecting");
          return;
        }
        console.log("Redirecting to: " + name);
        workAccountInput.setAttribute("disabled", "disabled");
        loginMainButton.setAttribute("disabled", "disabled");
        currentRedirect = provider;
        enterCount = 0;
        idpOrgName.textContent = name;
        idpOrgName.href = addTargetParameter(url);
        AJS.$(redirInd).removeClass("hidden");
        resizeContainer();
        start = new Date().getTime();

        autoRedirect = setTimeout(function () {
          if (provider.useHostedDomain === "true" && provider.hostedDomain
              && !url.includes("login_hint")) {
            url += "?hd=" + provider.hostedDomain;
          }
          redirect(url);
        }, redirectProgressDelay);
      }

      function orgSelected(e) {
        e.preventDefault();
        var url = e.target.getAttribute("data-login-url");
        var sendLoginHint = e.target.getAttribute("sendLoginHint");
        var account = workAccountInput.value.trim();
        console.log('Clicked on org, username: ' + account + " sendLoginHint: " + sendLoginHint);
        if (sendLoginHint === "true" && account.length > 0 && url.indexOf("username=") === -1) {
          var encodedAccount = encodeURIComponent(account)
          if (encodedAccount) {
            console.log("Adding login_hint: " + encodedAccount);
            url += "?username=" + encodedAccount + "&login_hint="
                + encodedAccount;
          }
        }
        redirect(url);
      }

      function createProvider(idp) {
        var li = document.createElement("li");
        var a = document.createElement("a");
        a.textContent = idp.name;
        a.setAttribute("href", "#");
        a.setAttribute("sendLoginHint", idp.sendLoginHint);
        if (idp.useHostedDomain === "true" && idp.hostedDomain) {
          a.setAttribute("data-login-url",
              idp.loginUrl + "?hd=" + idp.hostedDomain);
        } else {
          a.setAttribute("data-login-url", idp.loginUrl);
        }
        a.addEventListener("click", orgSelected);
        li.appendChild(a);
        return li;
      }

      function findLastProvider() {
        var xhr = new XMLHttpRequest();
        xhr.onreadystatechange = function () {
          if (xhr.readyState === 4) {
            if (xhr.status === 200) {
              var data;
              try {
                data = JSON.parse(xhr.responseText);
              } catch (e) {
                console.log(
                    "Error parsing SAML provider data, falling back to username/password"
                );
                enterUsernamePassword();
                return;
              }
              if (!data.enableWorkAccount) {
                enterUsernamePassword();
              }

              redirectProgressDelay = data.redirectProgressDelay;

              if (data.visible && data.visible.length > 0) {
                visibleProviders = data.visible;
                visibleProviders.sort(function (a, b) {
                  return a.name.localeCompare(b.name);
                });
                showProviderSelectionList([]);
              }
              if (data.auto && data.auto.length > 0) {
                if (data.auto.length === 1) {
                  if (!data.isAuthenticated && !hookOptions.manual) {
                    redirectTo(data.auto[0]);
                  } else {
                    currentRedirect = data.auto[0];
                    cancelRedirect();
                  }
                } else {
                  showProviderSelectionList(data.auto);
                }
              } else if (data.last) {
                if (!loginform.querySelector(".aui-message.error")) {
                  enterWorkAccount();
                  var url = data.last.loginUrl;
                  if (data.last.account) {
                    workAccountInput.value = data.last.account;
                    url += "?username=" + encodeURIComponent(data.last.account);
                  }
                  data.last.loginUrl = url;

                  if (!hookOptions.manual) {
                    redirectTo(data.last);
                  } else {
                    currentRedirect = data.last;
                    cancelRedirect();
                  }

                }
              }
            } else {
              console.log(
                  "Unexpected response code " +
                  xhr.status +
                  "fetching last SAML provider"
              );
              enterUsernamePassword();
            }
          }
        };

        xhr.open(
            "POST",
            findContextPath() + "/plugins/servlet/no.kantega.saml/discover"
        );
        xhr.setRequestHeader(
            "Content-Type",
            "application/x-www-form-urlencoded"
        );
        xhr.send("public=");
      }

      function clearErrors() {
        AJS.$(workAccountSelection).addClass("hidden");
        loginMainButton.removeAttribute("disabled");
      }

      function enterWorkAccount() {
        AJS.$(loginform).addClass("work-account-login");
        AJS.$(workAccountForm).removeClass("up-login");
        workAccountInput.focus();
        resizeContainer();
      }

      function enterUsernamePassword() {
        AJS.$(".use-up-link-container").addClass("hidden");
        AJS.$(loginform).removeClass("work-account-login");
        AJS.$(workAccountForm).addClass("up-login");
        usernameInput.focus();
        showProviderSelectionList([]);

        if (username_password_disabled_text) {
          username_password_disabled_text.style.display = "none";
          document
          .querySelector("#unknown_username_text")
          .setAttribute("style", "display: block; margin-bottom: 10px");

          var back = document.querySelector("#disabled_login_back_button");
          back.setAttribute("style", "display: block; margin-top:10px;");
          back.addEventListener("click", function () {
            usernameInput.samlComplete = false;
            setup();
          });

          username_password_disabled_text.style.display = "block";
        }

        resizeContainer();
      }

      function submitWorkAccount() {
        console.log("Submit work");
        var account = workAccountInput.value;
        workAccountInput.accountDirty = false;
        if (account.trim().length > 0) {
          findProviders(account.trim(), {fallbackRedirection: true});
        }
      }

      if (usernameInput != null && !usernameInput.samlComplete) {
        usernameInput.samlComplete = true;
        console.log("Username input found, doing setup");

        var children = loginform.querySelectorAll(
            "div.field-group, div.group, fieldset.group, .buttons-container, div.aui-group"
        );
        for (var i = 0; i < children.length; i++) {
          var ch = children[i];
          AJS.$(ch).addClass("up-login-row");
        }
        AJS.$(usernameInput).addClass("up-login");
        usernameInput.form.style.paddingBottom = "0";

        AJS.$(usernameInput).addClass("ajs-dirty-warning-exempt");

        workAccountSection = document.getElementById("workAccountSection");

        var div = document.createElement("div");
        div.innerHTML = document.querySelector(
            "#work-account-template"
        ).textContent;

        while (div.firstElementChild) {
          var c = div.firstElementChild;
          div.removeChild(c);
          loginform.parentNode.appendChild(c);
        }

        workAccountForm = document.querySelector("#workAccountForm");
        if (AJS.$(usernameInput.form).hasClass("top-label")) {
          AJS.$(workAccountForm).addClass("top-label");
        }
        idpOrgName = document.querySelector("#idpOrgName");
        redirInd = document.querySelector("#redirectIndicator");
        workAccountInput = document.querySelector("#login-form-workaccount");

        usernameInput.addEventListener("blur", function () {
          console.trace("Username blur");
          var isUsernameInputFieldVisible = !loginform.classList.contains(
              "work-account-login");
          if (isUsernameInputFieldVisible && usernameInput.accountDirty) {
            console.trace("Username blur - Find providers");
            findProviders(usernameInput.value, {fallbackRedirection: false});
            usernameInput.accountDirty = false;
          }
        });

        usernameInput.addEventListener("keydown", function (e) {
          if (e.key !== "Tab") {
            e.target.accountDirty = true;
          }
        });

        AJS.$(workAccountInput).addClass("ajs-dirty-warning-exempt");

        workAccountInput.addEventListener("keydown", function (e) {
          if (e.key !== "Tab") {
            e.target.accountDirty = true;
          }
        });

        var cancelRedirectLink = document.querySelector("#cancelRedirectLink");

        cancelRedirectLink.addEventListener("click", function (e) {
          e.preventDefault();
          cancelRedirect();
        });

        window.addEventListener("keyup", function (e) {
          if (e.key === "Escape" && autoRedirect) {
            cancelRedirect();
          }
          if (e.key === "Enter" && autoRedirect && currentRedirect) {
            if (enterCount++ > 0) {
              redirect(currentRedirect.loginUrl);
            }
          }
        });

        window.addEventListener("blur", function (e) {
          windowBlurred = true;
        });

        window.addEventListener("focus", function (e) {
          windowBlurred = false;
        });

        var osDestination = document.querySelector(
            "input[name='os_destination']"
        );
        if (osDestination) {
          target = osDestination.value;
          if (!isAbsolute(target)) {
            if (target.indexOf("/") !== 0) {
              target = "/" + target;
            }
            target = findContextPath() + target;
          }
        }
        if (!target) {
          // Bitbucket
          var qs = usernameInput.form.querySelector(
              "input[name='queryString']"
          );
          if (qs) {
            var nextplace = qs.value.indexOf("next=");
            if (nextplace > -1) {
              var prepareTarget = qs.value.substr(nextplace + 5);
              nextplace = prepareTarget.indexOf("&");
              if (nextplace > -1) {
                prepareTarget = prepareTarget.substr(0, nextplace);
              }
            }
            if (prepareTarget) {
              // 'next' may be encoded & absolute. e.g. "https%3A%2F%2Fbitbucket.example.com%3A8443%2Fbitbucket%2Fprojects%2FPROJECT_1%2Frepos%2Frep_1%2Fpull-requests%2F3%2Fdiff%23test2.txt"
              var prepareTargetDecoded = decodeURIComponent(prepareTarget);
              if (isAbsolute(prepareTargetDecoded)) {
                target = prepareTargetDecoded;
              } else {
                console.log(
                    "Target is prepareTargetDecoded: " + prepareTargetDecoded);
                target = findContextPath() + prepareTargetDecoded;
              }
            }
          }
          var next = usernameInput.form.querySelector("input[name='next']");
          if (!target && next) {
            var nextDecoded = decodeURIComponent(next.value);
            if (isAbsolute(nextDecoded)) {
              target = nextDecoded;
            } else {
              console.log("Target is nextDecoded: " + nextDecoded);
              target = findContextPath() + nextDecoded;
            }
          }
        }
        if (!target) {
          // Fecru
          var origUrl = usernameInput.form.querySelector(
              "input[name='origUrl']"
          );
          if (origUrl) {
            target = origUrl.value;
          }
        }
        if (!target) {
          // Service Desk
          var qs = location.search;
          var destStart = qs.indexOf("destination=");
          if (
              destStart !== -1 &&
              location.pathname.indexOf("servicedesk/customer/") !== -1
          ) {
            var dest = qs.substr(destStart + "destination=".length);
            if (dest.indexOf("&") !== -1) {
              dest = dest.substr(0, dest.indexOf("&"));
            }

            dest = decodeURIComponent(dest)
            var baseContext = findContextPath() + "/servicedesk/customer";
            if (dest.indexOf(baseContext) === 0) {
              // dest may already be prefixed with full context path, don't double-prefix. E.g.:
              // GET /jira/servicedesk/ (=> dest: portal/1)
              // GET /jira/servicedesk/customershim/secure/attachment/10015/10015_foo.png?fromIssue=10007 (=> dest: /jira/servicedesk/customershim/secure/attachment/10015/10015_foo.png?fromIssue=10007)
              target = dest;
            } else {
              target = baseContext + "/" + dest;
            }
          }
        } //End of JSD specific handling

        loginMainButton = document.querySelector("#loginMainButton");

        workAccountForm.addEventListener("submit", function (e) {
          e.preventDefault();
          if (e.stopPropagation) {
            e.stopPropagation();
          } else {
            e.cancelBubble = true;
          }
          submitWorkAccount();
          return false;
        });

        workAccountList = document.getElementById("workAccountList");
        workAccountSelection = document.getElementById(
            "work-account-selection"
        );

        var upLinks = document.querySelectorAll("a.use-up-link");
        for (var i = 0; i < upLinks.length; i++) {
          upLinks[i].addEventListener("click", function (e) {
            e.preventDefault();
            usernameInput.value = workAccountInput.value;
            enterUsernamePassword();
            passwordInput.focus();
          });
        }

        findLastProvider();

        if (!loginform.querySelector(".aui-message.error")) {
          enterWorkAccount();
        }

        if ("gadgets" in window) {
          AJS.$("#loginMethodDropdownWa").on({
            "aui-dropdown2-show": function () {
              dropdownOpen = true;
              resizeContainer();
            },
            "aui-dropdown2-hide": function (event) {
              dropdownOpen = false;
              resizeContainer();
            }
          });
        }

        // Build own forgot password link
        var forgotPwLinks = document.getElementsByClassName(
            "js-forgot-password");
        if (forgotPwLinks.length > 0) {
          console.log("Preparing forgot password link");
          forgotPwLinks[0].style.display = "none";
          var forgotPasswordLink = document.getElementById(
              "forgotPasswordLink");
          forgotPasswordLink.style.display = "inline";
          forgotPasswordLink.onclick = function () {
            linkClicked = true;
          };
        }

        var customerSignupLink = document.getElementById(
            "customer-signup-link");
        if (customerSignupLink !== null) {
          console.log("Preparing customer signup link");
          customerSignupLink.onclick = function () {
            linkClicked = true;
          };
        }

      } else {
        console.log("Username input not found, skipping setup");
      }
    }

    if (usernameInput) {
      console.log("Found usernameInput on first run, running setup");
      setup();
    }
    if ("MutationObserver" in window) {
      var obs = new MutationObserver(function (mutations, observer) {
        if (!linkClicked) {
          console.log("Observed mutation");
          setup();
        } else {
          console.log("Ignoring mutation since link is clicked");
          if (typeof emailFromHeader !== 'undefined' && emailFromHeader) {
            prepareSignup(emailFromHeader);
          }
        }
      });

      obs.observe(document.body, {childList: true, subtree: true});
    } else {
      document.body.addEventListener(
          "DOMNodeInserted",
          function (e) {
            console.log("DOMNodeInserted: " + e);
          },
          true
      );
    }
  });
};
