function probeHeaderSize(
    size,
    lastworks,
    lastnotworks,
    lastnotworksxhr,
    callback,
    server
) {
  var xhr = new XMLHttpRequest();
  xhr.onreadystatechange = function () {
    if (!server) {
      server = xhr.getResponseHeader("Server");
    }

    if (xhr.readyState == 4) {
      if (xhr.status == 404) {
        var next =
            lastnotworks == -1 ? size * 2 : size + (lastnotworks - size) / 2;
        console.log(
            "Working " +
            size +
            ", lastnotworks=" +
            lastnotworks +
            ", next: " +
            next
        );
        if (next - size > 100) {
          probeHeaderSize(
              next,
              size,
              lastnotworks,
              lastnotworksxhr,
              callback,
              server
          );
        } else {
          callback(size, lastnotworks, lastnotworksxhr, server);
        }
      } else {
        var next = lastworks == -1 ? size / 2 : size - (size - lastworks) / 2;
        console.log(
            "Not working " + size + ", lastworks=" + lastworks + ", next: "
            + next
        );
        if (size - next > 100) {
          probeHeaderSize(next, lastworks, size, xhr, callback, server);
        } else {
          callback(lastworks, size, xhr, server);
        }
      }
    }
  };
  var val = "";
  for (var i = 0; i < size; i++) {
    val += "x";
  }
  console.log("Trying " + size);
  xhr.open("GET", "404-pagenotfound");
  xhr.setRequestHeader("X-BigData", val);
  xhr.send(null);
}

window.addEventListener("load", function () {
  function copyText(e) {
    e.preventDefault();
    var fromId;

    var from = e.target;

    while (!(fromId = from.getAttribute("data-copy-from"))) {
      console.log(from);
      from = from.parentNode;
    }
    if (!fromId) {
      return;
    }

    var elem = document.getElementById(from.getAttribute("data-copy-from"));
    try {
      elem.select();
      document.execCommand("copy");
    } catch (ex) {
      window.prompt("Copy to clipboard", elem.value);
    }

    try {
      window.getSelection().removeAllRanges();
    } catch (ex) {
    }
  }

  var clips = document.querySelectorAll(".cpl-copy");

  for (var i = 0; i < clips.length; i++) {
    clips[i].addEventListener("click", copyText);
  }
});
