/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import shaded.org.bouncycastle.asn1.LimitedInputStream;
import shaded.org.bouncycastle.util.io.Streams;

class DefiniteLengthInputStream
extends LimitedInputStream {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private int _length;

    DefiniteLengthInputStream(InputStream inputStream2, int n) {
        super(inputStream2);
        if (n < 0) {
            throw new IllegalArgumentException("negative lengths not allowed");
        }
        this._length = n;
    }

    public int read() throws IOException {
        if (this._length > 0) {
            int n = this._in.read();
            if (n < 0) {
                throw new EOFException();
            }
            --this._length;
            return n;
        }
        this.setParentEofDetect(true);
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this._length > 0) {
            int n3 = Math.min(n2, this._length);
            int n4 = this._in.read(byArray, n, n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            this._length -= n4;
            return n4;
        }
        this.setParentEofDetect(true);
        return -1;
    }

    byte[] toByteArray() throws IOException {
        byte[] byArray;
        if (this._length > 0) {
            byArray = new byte[this._length];
            if (Streams.readFully(this._in, byArray) < this._length) {
                throw new EOFException();
            }
            this._length = 0;
        } else {
            byArray = EMPTY_BYTES;
        }
        this.setParentEofDetect(true);
        return byArray;
    }
}

