/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.asn1;

import java.io.IOException;
import shaded.org.bouncycastle.asn1.ASN1Object;
import shaded.org.bouncycastle.asn1.ASN1OctetString;
import shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import shaded.org.bouncycastle.asn1.DERObject;
import shaded.org.bouncycastle.asn1.DEROutputStream;
import shaded.org.bouncycastle.asn1.DERString;
import shaded.org.bouncycastle.util.Strings;

public class DERUTF8String
extends ASN1Object
implements DERString {
    String string;

    public static DERUTF8String getInstance(Object object) {
        if (object == null || object instanceof DERUTF8String) {
            return (DERUTF8String)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERUTF8String(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERUTF8String.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERUTF8String getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERUTF8String.getInstance(aSN1TaggedObject.getObject());
    }

    DERUTF8String(byte[] byArray) {
        this.string = Strings.fromUTF8ByteArray((byte[])byArray);
    }

    public DERUTF8String(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERUTF8String)) {
            return false;
        }
        DERUTF8String dERUTF8String = (DERUTF8String)dERObject;
        return this.getString().equals(dERUTF8String.getString());
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(12, Strings.toUTF8ByteArray((String)this.string));
    }
}

