/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.asn1;

import java.io.IOException;
import java.io.InputStream;
import shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import shaded.org.bouncycastle.asn1.ASN1StreamParser;
import shaded.org.bouncycastle.asn1.ASN1TaggedObjectParser;
import shaded.org.bouncycastle.asn1.BERFactory;
import shaded.org.bouncycastle.asn1.BEROctetStringParser;
import shaded.org.bouncycastle.asn1.BERSequenceParser;
import shaded.org.bouncycastle.asn1.BERSetParser;
import shaded.org.bouncycastle.asn1.BERTaggedObject;
import shaded.org.bouncycastle.asn1.DEREncodable;
import shaded.org.bouncycastle.asn1.DERFactory;
import shaded.org.bouncycastle.asn1.DERObject;
import shaded.org.bouncycastle.asn1.DEROctetString;
import shaded.org.bouncycastle.asn1.DEROctetStringParser;
import shaded.org.bouncycastle.asn1.DERSequenceParser;
import shaded.org.bouncycastle.asn1.DERSetParser;
import shaded.org.bouncycastle.asn1.DERTaggedObject;
import shaded.org.bouncycastle.asn1.DefiniteLengthInputStream;
import shaded.org.bouncycastle.asn1.IndefiniteLengthInputStream;

public class BERTaggedObjectParser
implements ASN1TaggedObjectParser {
    private int _baseTag;
    private int _tagNumber;
    private InputStream _contentStream;
    private boolean _indefiniteLength;

    protected BERTaggedObjectParser(int n, int n2, InputStream inputStream2) {
        this._baseTag = n;
        this._tagNumber = n2;
        this._contentStream = inputStream2;
        this._indefiniteLength = inputStream2 instanceof IndefiniteLengthInputStream;
    }

    public boolean isConstructed() {
        return (this._baseTag & 0x20) != 0;
    }

    public int getTagNo() {
        return this._tagNumber;
    }

    public DEREncodable getObjectParser(int n, boolean bl) throws IOException {
        if (bl) {
            return new ASN1StreamParser(this._contentStream).readObject();
        }
        switch (n) {
            case 17: {
                if (this._indefiniteLength) {
                    return new BERSetParser(new ASN1StreamParser(this._contentStream));
                }
                return new DERSetParser(new ASN1StreamParser(this._contentStream));
            }
            case 16: {
                if (this._indefiniteLength) {
                    return new BERSequenceParser(new ASN1StreamParser(this._contentStream));
                }
                return new DERSequenceParser(new ASN1StreamParser(this._contentStream));
            }
            case 4: {
                if (this._indefiniteLength || this.isConstructed()) {
                    return new BEROctetStringParser(new ASN1StreamParser(this._contentStream));
                }
                return new DEROctetStringParser((DefiniteLengthInputStream)this._contentStream);
            }
        }
        throw new RuntimeException("implicit tagging not implemented");
    }

    private ASN1EncodableVector rLoadVector(InputStream inputStream2) {
        try {
            return new ASN1StreamParser(inputStream2).readVector();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }

    public DERObject getDERObject() {
        if (this._indefiniteLength) {
            ASN1EncodableVector aSN1EncodableVector = this.rLoadVector(this._contentStream);
            return aSN1EncodableVector.size() == 1 ? new BERTaggedObject(true, this._tagNumber, aSN1EncodableVector.get(0)) : new BERTaggedObject(false, this._tagNumber, BERFactory.createSequence(aSN1EncodableVector));
        }
        if (this.isConstructed()) {
            ASN1EncodableVector aSN1EncodableVector = this.rLoadVector(this._contentStream);
            return aSN1EncodableVector.size() == 1 ? new DERTaggedObject(true, this._tagNumber, aSN1EncodableVector.get(0)) : new DERTaggedObject(false, this._tagNumber, DERFactory.createSequence(aSN1EncodableVector));
        }
        try {
            DefiniteLengthInputStream definiteLengthInputStream = (DefiniteLengthInputStream)this._contentStream;
            return new DERTaggedObject(false, this._tagNumber, new DEROctetString(definiteLengthInputStream.toByteArray()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }
}

