/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import shaded.org.bouncycastle.asn1.BERConstructedOctetString;
import shaded.org.bouncycastle.asn1.BERConstructedSequence;
import shaded.org.bouncycastle.asn1.BERSet;
import shaded.org.bouncycastle.asn1.BERTaggedObject;
import shaded.org.bouncycastle.asn1.DERInputStream;
import shaded.org.bouncycastle.asn1.DERObject;
import shaded.org.bouncycastle.asn1.DEROctetString;
import shaded.org.bouncycastle.asn1.DEROutputStream;
import shaded.org.bouncycastle.asn1.DERTaggedObject;

public class BERInputStream
extends DERInputStream {
    private static final DERObject END_OF_STREAM = new DERObject(){

        void encode(DEROutputStream dEROutputStream) throws IOException {
            throw new IOException("Eeek!");
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return object == this;
        }
    };

    public BERInputStream(InputStream inputStream2) {
        super(inputStream2);
    }

    private byte[] readIndefiniteLengthFully() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = this.read();
        while ((n = this.read()) >= 0 && (n2 != 0 || n != 0)) {
            byteArrayOutputStream.write(n2);
            n2 = n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private BERConstructedOctetString buildConstructedOctetString() throws IOException {
        DERObject dERObject;
        Vector<DERObject> vector = new Vector<DERObject>();
        while ((dERObject = this.readObject()) != END_OF_STREAM) {
            vector.addElement(dERObject);
        }
        return new BERConstructedOctetString(vector);
    }

    public DERObject readObject() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        int n2 = this.readLength();
        if (n2 < 0) {
            switch (n) {
                case 5: {
                    return null;
                }
                case 48: {
                    DERObject dERObject;
                    BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
                    while ((dERObject = this.readObject()) != END_OF_STREAM) {
                        bERConstructedSequence.addObject(dERObject);
                    }
                    return bERConstructedSequence;
                }
                case 36: {
                    return this.buildConstructedOctetString();
                }
                case 49: {
                    DERObject dERObject;
                    ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                    while ((dERObject = this.readObject()) != END_OF_STREAM) {
                        aSN1EncodableVector.add(dERObject);
                    }
                    return new BERSet(aSN1EncodableVector);
                }
            }
            if ((n & 0x80) != 0) {
                if ((n & 0x1F) == 31) {
                    throw new IOException("unsupported high tag encountered");
                }
                if ((n & 0x20) == 0) {
                    byte[] byArray = this.readIndefiniteLengthFully();
                    return new BERTaggedObject(false, n & 0x1F, new DEROctetString(byArray));
                }
                DERObject dERObject = this.readObject();
                if (dERObject == END_OF_STREAM) {
                    return new DERTaggedObject(n & 0x1F);
                }
                DERObject dERObject2 = this.readObject();
                if (dERObject2 == END_OF_STREAM) {
                    return new BERTaggedObject(n & 0x1F, dERObject);
                }
                BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
                bERConstructedSequence.addObject(dERObject);
                do {
                    bERConstructedSequence.addObject(dERObject2);
                } while ((dERObject2 = this.readObject()) != END_OF_STREAM);
                return new BERTaggedObject(false, n & 0x1F, bERConstructedSequence);
            }
            throw new IOException("unknown BER object encountered");
        }
        if (n == 0 && n2 == 0) {
            return END_OF_STREAM;
        }
        byte[] byArray = new byte[n2];
        this.readFully(byArray);
        return this.buildObject(n, byArray);
    }
}

