/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.serberuhs.keytab;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.simplericity.serberuhs.keytab.KeytabInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeytabParser {
    public List<KeytabInfo> parse(InputStream resource) {
        try {
            DataInputStream is = new DataInputStream(this.byteArrayStream(resource));
            ArrayList<KeytabInfo> infos = new ArrayList<KeytabInfo>();
            short fileFormatVersion = is.readShort();
            while (is.available() > 0) {
                int size = is.readInt();
                if (size <= 0) {
                    is.read(new byte[Math.abs(size)]);
                    continue;
                }
                int byteCount = 0;
                int components = is.readShort();
                byteCount += 2;
                byte[] realm = this.readOctetString(is);
                byteCount += realm.length + 2;
                String serviceType = null;
                String host = null;
                for (int i = 0; i < components; ++i) {
                    byte[] comp = this.readOctetString(is);
                    byteCount += comp.length + 2;
                    String compString = new String(comp, "utf-8");
                    if (i == 0) {
                        serviceType = compString;
                        continue;
                    }
                    if (i != 1) continue;
                    host = compString;
                }
                int nameType = is.readInt();
                byteCount += 4;
                int timestamp = is.readInt();
                byteCount += 4;
                int kvno = is.read();
                ++byteCount;
                short keyBlockType = is.readShort();
                byteCount += 2;
                byte[] key = this.readOctetString(is);
                if (size - (byteCount += key.length + 2) >= 4) {
                    int extKvno = is.readInt();
                    if (extKvno != 0) {
                        kvno = extKvno;
                    }
                    byteCount += 4;
                }
                if (size - byteCount >= 4) {
                    int flags = is.readInt();
                    byteCount += 4;
                }
                if (size > byteCount) {
                    byte[] rest = new byte[size - byteCount];
                    is.read(rest);
                }
                infos.add(new DefaultKeytabInfo(new String(realm, "utf-8"), serviceType, host, kvno, keyBlockType));
            }
            return infos;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream byteArrayStream(InputStream resource) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int r = 0;
        while ((r = resource.read(buffer)) > 0) {
            out.write(buffer, 0, r);
        }
        resource.close();
        return new ByteArrayInputStream(out.toByteArray());
    }

    private byte[] readOctetString(DataInputStream is) throws IOException {
        short size = is.readShort();
        byte[] bytes = new byte[size];
        is.read(bytes);
        return bytes;
    }

    private static class DefaultKeytabInfo
    implements KeytabInfo {
        private final String realm;
        private final String servicePart;
        private final String hostPart;
        private final int kvno;
        private final int encType;

        public DefaultKeytabInfo(String realm, String servicePart, String hostPart, int kvno, int encType) {
            this.realm = realm;
            this.servicePart = servicePart;
            this.hostPart = hostPart;
            this.kvno = kvno;
            this.encType = encType;
        }

        public String getHostPart() {
            return this.hostPart;
        }

        public int getKvno() {
            return this.kvno;
        }

        public int getEncType() {
            return this.encType;
        }

        public String getRealm() {
            return this.realm;
        }

        public String getServicePart() {
            return this.servicePart;
        }
    }
}

