/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.serberuhs.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.simplericity.serberuhs.DefaultKerberosSubjectFactory;
import org.simplericity.serberuhs.KerberosSubjectFactory;
import org.simplericity.serberuhs.SpNego;
import org.simplericity.serberuhs.SpNegoResult;
import org.simplericity.serberuhs.filter.DefaultFilterConfiguration;
import org.simplericity.serberuhs.filter.KerberosFilterConfiguration;

public class KerberosFilter
implements Filter {
    private KerberosSubjectFactory factory;
    private KerberosFilterConfiguration configuration;
    public static final String AUTORIZED_PRINCIPAL_SESSION_ATTRIBUTE = KerberosFilter.class.getName() + "_AUTHORIZED_PRINCIPAL";

    public final void init(FilterConfig filterConfig) throws ServletException {
        DefaultKerberosSubjectFactory factory2 = new DefaultKerberosSubjectFactory();
        this.configuration = this.createConfiguration(filterConfig);
        factory2.setConfiguration(this.configuration);
        this.factory = factory2;
    }

    protected KerberosFilterConfiguration createConfiguration(FilterConfig filterConfig) {
        return new DefaultFilterConfiguration(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.configuration.isEnabled()) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            SpNego spNego = this.createSpNego();
            spNego.negotiate(this.factory.getSubject(), req, res);
            if (spNego.getResult() == SpNegoResult.AUTHORIZED) {
                this.handleSuccessfulAuthorization(spNego.getAuthorizedPrincipal(), req, res, chain);
            } else if (spNego.getResult() == SpNegoResult.MISSING_AUTHORIZATION_HEADER) {
                this.handleMissingAuthorizationHeader(req, res, chain);
            } else {
                this.handleUnsuccessfulAutorization(spNego, req, res, chain);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    protected SpNego createSpNego() {
        return new SpNego();
    }

    public void setFactory(KerberosSubjectFactory factory2) {
        this.factory = factory2;
    }

    public void setConfiguration(KerberosFilterConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void dispatchToFallback(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.configuration.getFallbackLoginPath() != null) {
            req.getRequestDispatcher(this.configuration.getFallbackLoginPath()).forward((ServletRequest)req, (ServletResponse)res);
        }
    }

    protected void handleMissingAuthorizationHeader(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.dispatchToFallback(req, res);
    }

    protected void handleUnsuccessfulAutorization(SpNego spNego, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.dispatchToFallback(req, res);
    }

    protected void handleSuccessfulAuthorization(String authorizedPrincipal, HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.exposeSessionAttribute(authorizedPrincipal, req);
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    protected void exposeSessionAttribute(String authorizedPrincipal, HttpServletRequest req) {
        req.getSession().setAttribute(AUTORIZED_PRINCIPAL_SESSION_ATTRIBUTE, (Object)authorizedPrincipal);
    }

    public void destroy() {
    }
}

