/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.serberuhs;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.simplericity.serberuhs.KerberosSubjectConfiguration;
import org.simplericity.serberuhs.KerberosSubjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKerberosSubjectFactory
implements KerberosSubjectFactory {
    private static Logger log = LoggerFactory.getLogger(DefaultKerberosSubjectFactory.class);
    private Subject subject;
    private KerberosSubjectConfiguration configuration;
    private static final String JAAS_ENTRYNAME = DefaultKerberosSubjectFactory.class.getName() + "_JAAS_ENTRYNAME";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Subject getSubject() {
        if (this.configuration == null) {
            throw new NullPointerException("Configuration must be set before calling getSubject");
        }
        if (this.subject == null) {
            Configuration existingConfiguration;
            block8: {
                existingConfiguration = null;
                try {
                    existingConfiguration = this.getSystemConfiguration();
                }
                catch (SecurityException e) {
                    if (!log.isDebugEnabled()) break block8;
                    log.debug("System wide JAAS is not configured properly");
                }
            }
            try {
                Configuration.setConfiguration(this.createConfiguration(existingConfiguration));
                this.subject = this.createSubject();
            }
            finally {
                if (existingConfiguration != null) {
                    Configuration.setConfiguration(existingConfiguration);
                }
            }
        }
        return this.subject;
    }

    protected Configuration getSystemConfiguration() {
        return Configuration.getConfiguration();
    }

    private Subject createSubject() {
        try {
            LoginContext context = new LoginContext(JAAS_ENTRYNAME, new CallbackHandler(){

                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (!(callback instanceof PasswordCallback)) continue;
                        ((PasswordCallback)callback).setPassword(DefaultKerberosSubjectFactory.this.configuration.getPassword().toCharArray());
                    }
                }
            });
            context.login();
            return context.getSubject();
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }

    Configuration createConfiguration(final Configuration existingConfiguration) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("useKeyTab", "true");
        options.put("keyTab", this.configuration.getKeytabFile().getAbsolutePath());
        options.put("storeKey", "true");
        options.put("isInitiator", "false");
        options.put("principal", this.configuration.getPrincipal());
        final AppConfigurationEntry entry = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        return new Configuration(){

            public AppConfigurationEntry[] getAppConfigurationEntry(String entryName) {
                if (JAAS_ENTRYNAME.equals(entryName)) {
                    return new AppConfigurationEntry[]{entry};
                }
                Configuration parentConfiguration = existingConfiguration == null ? DefaultKerberosSubjectFactory.this.getSystemConfiguration() : existingConfiguration;
                return parentConfiguration.getAppConfigurationEntry(entryName);
            }

            public void refresh() {
            }
        };
    }

    public final void setConfiguration(KerberosSubjectConfiguration configuration) {
        this.configuration = configuration;
    }

    public final synchronized void flushCache() {
        this.subject = null;
    }
}

