/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient;

import java.io.IOException;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.httpclient.HttpClientContextHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;

public class HttpClientSecurityContextHandler
extends AbstractInitializableComponent
implements HttpClientContextHandler {
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    @Nullable
    public HttpClientSecurityParameters getHttpClientSecurityParameters() {
        return this.httpClientSecurityParameters;
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.httpClientSecurityParameters = params;
    }

    @Override
    public void invokeBefore(HttpClientContext context, HttpUriRequest request) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        HttpClientSecuritySupport.marshalSecurityParameters(context, this.httpClientSecurityParameters, false);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria(context, request);
    }

    @Override
    public void invokeAfter(HttpClientContext context, HttpUriRequest request) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        HttpClientSecuritySupport.checkTLSCredentialEvaluated(context, request.getURI().getScheme());
    }
}

