/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kantega.shaded.com.google.common.base.Function;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexRequestURLBuilder
implements Function<CriteriaSet, String> {
    private final Logger log = LoggerFactory.getLogger(RegexRequestURLBuilder.class);
    private Pattern pattern;
    private String template;

    public RegexRequestURLBuilder(@Nonnull @NotEmpty String regex, @Nonnull @NotEmpty String replacement) {
        String regexTemp = Constraint.isNotNull(StringSupport.trimOrNull(regex), "Regex was null or empty");
        this.pattern = Pattern.compile(regexTemp);
        this.template = Constraint.isNotNull(StringSupport.trimOrNull(replacement), "Replacement template was null or empty");
    }

    @Override
    @Nullable
    public String apply(@Nonnull CriteriaSet criteria) {
        Constraint.isNotNull(criteria, "Criteria was null");
        if (!criteria.contains(EntityIdCriterion.class)) {
            this.log.trace("Criteria did not contain entity ID, unable to build request URL");
            return null;
        }
        String entityID = criteria.get(EntityIdCriterion.class).getEntityId();
        try {
            Matcher matcher = this.pattern.matcher(entityID);
            if (matcher.matches()) {
                String result = matcher.replaceAll(this.template);
                this.log.debug("Regular expression '{}' matched successfully against entity ID '{}', returning '{}'", new Object[]{this.pattern.pattern(), entityID, result});
                return result;
            }
            this.log.debug("Regular expression '{}' did not match against entity ID '{}', returning null", (Object)this.pattern.pattern(), (Object)entityID);
            return null;
        }
        catch (Throwable t) {
            this.log.warn("Error evaluating regular expression '{}' against entity ID '{}'", new Object[]{this.pattern.pattern(), entityID, t});
            return null;
        }
    }
}

