/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.saml.common.messaging.context.AbstractAuthenticatableSAMLEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;

public class OperationContextEntityIDLookup
implements ContextDataLookupFunction<MessageContext, String> {
    @Nonnull
    private Class<? extends AbstractAuthenticatableSAMLEntityContext> entityContextClass;
    @Nonnull
    private RecursiveTypedParentContextLookup<MessageContext, InOutOperationContext> parentLookup = new RecursiveTypedParentContextLookup(InOutOperationContext.class);

    public OperationContextEntityIDLookup() {
        this(SAMLPeerEntityContext.class);
    }

    public OperationContextEntityIDLookup(@Nonnull Class<? extends AbstractAuthenticatableSAMLEntityContext> clazz) {
        this.entityContextClass = Constraint.isNotNull(clazz, "The SAML Entity context class may not be null;");
    }

    @Override
    public String apply(@Nullable MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        InOutOperationContext opContext = this.parentLookup.apply(messageContext);
        if (opContext == null) {
            return null;
        }
        AbstractAuthenticatableSAMLEntityContext entityContext = opContext.getSubcontext(this.entityContextClass);
        if (entityContext == null) {
            return null;
        }
        return entityContext.getEntityId();
    }
}

