/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.AbstractSAMLEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;

public class SAMLProtocolAndRoleHandler
extends AbstractMessageHandler {
    @NonnullAfterInit
    @NotEmpty
    private String samlProtocol;
    @NonnullAfterInit
    private QName peerRole;
    @Nonnull
    private Class<? extends AbstractSAMLEntityContext> entityContextClass = SAMLPeerEntityContext.class;
    @Nullable
    private ContextDataLookupFunction<MessageContext, BaseContext> copyContextLookup;

    public void setCopyContextLookup(@Nullable ContextDataLookupFunction<MessageContext, BaseContext> lookup) {
        this.copyContextLookup = lookup;
    }

    public void setEntityContextClass(@Nonnull Class<? extends AbstractSAMLEntityContext> clazz) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.entityContextClass = Constraint.isNotNull(clazz, "SAML entity context class may not be null");
    }

    public void setProtocol(@Nonnull @NotEmpty String protocol) {
        this.samlProtocol = Constraint.isNotNull(StringSupport.trimOrNull(protocol), "SAML protocol cannot be null");
    }

    public void setRole(@Nonnull QName role) {
        this.peerRole = Constraint.isNotNull(role, "SAML peer role cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.copyContextLookup == null && (this.samlProtocol == null || this.peerRole == null)) {
            throw new ComponentInitializationException("Either SAML protocol and peer role, or context copy function must be supplied");
        }
    }

    protected void doInvoke(MessageContext messageContext) throws MessageHandlerException {
        AbstractSAMLEntityContext sourceEntityContext;
        SAMLProtocolContext sourceProtocolContext;
        BaseContext copySource = null;
        if (this.copyContextLookup != null) {
            copySource = (BaseContext)this.copyContextLookup.apply(messageContext);
        }
        if (this.samlProtocol != null) {
            messageContext.getSubcontext(SAMLProtocolContext.class, true).setProtocol(this.samlProtocol);
        } else if (copySource != null && (sourceProtocolContext = copySource.getSubcontext(SAMLProtocolContext.class)) != null) {
            messageContext.getSubcontext(SAMLProtocolContext.class, true).setProtocol(sourceProtocolContext.getProtocol());
        }
        if (messageContext.getSubcontext(SAMLProtocolContext.class, true).getProtocol() == null) {
            throw new MessageHandlerException("SAML protocol was not supplied and could not be dynamically resolved");
        }
        if (this.peerRole != null) {
            messageContext.getSubcontext(this.entityContextClass, true).setRole(this.peerRole);
        } else if (copySource != null && (sourceEntityContext = copySource.getSubcontext(this.entityContextClass)) != null) {
            messageContext.getSubcontext(this.entityContextClass, true).setRole(sourceEntityContext.getRole());
        }
        if (messageContext.getSubcontext(this.entityContextClass, true).getRole() == null) {
            throw new MessageHandlerException("SAML role was not supplied and could not be dynamically resolved");
        }
    }
}

