/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.encoder;

import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponent;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;

public abstract class AbstractMessageEncoder<MessageType>
extends AbstractInitializableComponent
implements MessageEncoder<MessageType>,
UnmodifiableComponent {
    private MessageContext<MessageType> messageContext;

    @Override
    public synchronized void setMessageContext(MessageContext<MessageType> context) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.messageContext = context;
    }

    @Override
    public void encode() throws MessageEncodingException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.doEncode();
    }

    @Override
    public void prepareContext() throws MessageEncodingException {
    }

    protected MessageContext<MessageType> getMessageContext() {
        return this.messageContext;
    }

    @Override
    protected void doDestroy() {
        this.messageContext = null;
        super.doDestroy();
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.messageContext == null) {
            throw new ComponentInitializationException("Message context cannot be null");
        }
    }

    protected abstract void doEncode() throws MessageEncodingException;
}

