/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.samllib.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.joda.time.DateTime;
import org.kantega.samllib.spi.AuthnStateCache;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.kantega.samllib.validation.AbstractSamlValidator;
import org.kantega.samllib.validation.ResultType;
import org.kantega.samllib.validation.SAMLSessionIdentification;
import org.kantega.samllib.validation.SamlResponseValidationResult;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.EncryptedElementTypeEncryptedKeyResolver;
import org.opensaml.storage.ReplayCache;
import org.opensaml.xmlsec.encryption.support.ChainingEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.SimpleRetrievalMethodEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlResponseValidator
extends AbstractSamlValidator {
    private static final Logger log = LoggerFactory.getLogger(SamlResponseValidator.class);
    private final ReplayCache replayCache;
    private final AuthnStateCache authnStateCache;

    public SamlResponseValidator(ReplayCache replayCache, AuthnStateCache authnStateCache, ServiceProviderSpi serviceProviderSpi) {
        super(serviceProviderSpi);
        this.replayCache = replayCache;
        this.authnStateCache = authnStateCache;
    }

    public void validate(Response samlResponse, SamlResponseValidationResult result) {
        result.setResponseObject(samlResponse);
        this.validateSignature(samlResponse, result, null, ResultType.RESPONSE_SIGNATURE_UNKNOWN_SIGNING_CERTIFICATE, ResultType.RESPONSE_SIGNATURE_FAILED_VALIDATION);
        this.validateSamlResponse(samlResponse, result);
    }

    private void validateSamlResponse(Response samlResponse, SamlResponseValidationResult result) {
        List<Assertion> assertions;
        this.validateStatus(samlResponse.getStatus(), result);
        if (!result.hasErrors() && !(assertions = this.findAssertions(samlResponse, result)).isEmpty()) {
            this.validateAuthStatement(assertions, result);
            this.validateSubjectConfirmation(assertions, result);
            for (Assertion assertion : assertions) {
                this.validateAssertion(assertion, result);
            }
            if (this.serviceProviderSpi.isSingleLogoutEnabled()) {
                this.validateNameIdentifier(assertions, result);
            }
        }
        if (samlResponse.getIssueInstant() == null) {
            result.addResult(ResultType.MISSING_ISSUE_INSTANT);
        }
    }

    private void validateNameIdentifier(List<Assertion> assertions, SamlResponseValidationResult result) {
        for (Assertion assertion : assertions) {
            Optional<String> sessionIndex;
            List<AuthnStatement> authnStatements;
            Subject subject = assertion.getSubject();
            NameID nameID = subject.getNameID();
            if (nameID == null || (authnStatements = assertion.getAuthnStatements()) == null || authnStatements.isEmpty() || !(sessionIndex = authnStatements.stream().map(AuthnStatement::getSessionIndex).filter(i -> i != null && !i.isEmpty()).findFirst()).isPresent()) continue;
            result.setSessionIdentification(new SAMLSessionIdentification(this.serviceProviderSpi.getIdentityProviderId(), nameID.getValue(), nameID.getFormat(), sessionIndex.get()));
            return;
        }
        result.addResult(ResultType.RESPONSE_MISSING_NAME_IDENTIFIER);
    }

    private List<Assertion> findAssertions(Response samlResponse, SamlResponseValidationResult result) {
        if (this.serviceProviderSpi.isEncryptedAssertionsRequired()) {
            List<EncryptedAssertion> encryptedAssertions = samlResponse.getEncryptedAssertions();
            if (encryptedAssertions.isEmpty()) {
                result.addResult(ResultType.MISSING_ENCRYPTED_ASSERTIONS);
                return Collections.emptyList();
            }
            return this.decryptAssertions(encryptedAssertions, result);
        }
        List<Assertion> assertions = samlResponse.getAssertions();
        if (assertions.isEmpty()) {
            result.addResult(ResultType.MISSING_ASSERTIONS);
        }
        return assertions;
    }

    private List<Assertion> decryptAssertions(List<EncryptedAssertion> encryptedAssertions, SamlResponseValidationResult result) {
        StaticKeyInfoCredentialResolver resolver = new StaticKeyInfoCredentialResolver(this.serviceProviderSpi.getSigningCredential());
        List<EncryptedKeyResolver> encKeyResolvers = Arrays.asList(new InlineEncryptedKeyResolver(), new EncryptedElementTypeEncryptedKeyResolver(), new SimpleRetrievalMethodEncryptedKeyResolver());
        ChainingEncryptedKeyResolver chainingResolver = new ChainingEncryptedKeyResolver(encKeyResolvers);
        Decrypter decrypter = new Decrypter(null, resolver, chainingResolver);
        decrypter.setRootInNewDocument(true);
        ArrayList<Assertion> decryptedAssertions = new ArrayList<Assertion>();
        try {
            for (EncryptedAssertion encryptedAssertion : encryptedAssertions) {
                decryptedAssertions.add(decrypter.decrypt(encryptedAssertion));
            }
            result.setDecryptedAssertions(decryptedAssertions);
            return decryptedAssertions;
        }
        catch (DecryptionException e) {
            log.debug("EncryptedAssertion could not be decrypted", (Throwable)e);
            result.addResult(ResultType.ASSERTION_DECRYPT_FAILED);
            return Collections.emptyList();
        }
    }

    private void validateSubjectConfirmation(List<Assertion> assertions, SamlResponseValidationResult result) {
        SubjectConfirmation subjectConfirmation = this.findSubjectConfirmationBearer(assertions);
        if (subjectConfirmation == null) {
            result.addResult(ResultType.MISSING_SUBJECT_CONFIRMATION_BEARER);
        } else if (subjectConfirmation.getSubjectConfirmationData() == null) {
            result.addResult(ResultType.MISSING_SUBJECT_CONFIRMATION_DATA, Collections.singletonMap("subjectConfirmation", subjectConfirmation));
        } else {
            boolean isOnOrAfter;
            SubjectConfirmationData subjectConfirmationData = subjectConfirmation.getSubjectConfirmationData();
            String subjConfInResponseTo = subjectConfirmationData.getInResponseTo();
            result.setAuthnRequestID(subjConfInResponseTo);
            if (subjectConfirmationData.getRecipient() == null) {
                result.addResult(ResultType.SUBJECT_CONFIRMATION_DATA_MISSING_RECIPIENT, Collections.singletonMap("subjectConfirmation", subjectConfirmation));
            } else if (!subjectConfirmationData.getRecipient().equals(result.getServiceProviderSpi().getACSLocation(result.getRequest()))) {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("subjectConfirmation", subjectConfirmation);
                model.put("recipient", subjectConfirmationData.getRecipient());
                model.put("expectedRecipient", result.getServiceProviderSpi().getACSLocation(result.getRequest()));
                result.addResult(ResultType.SUBJECT_CONFIRMATION_DATA_UNEXPECTED_RECIPIENT, model);
            } else {
                this.validateAudienceRestriction(subjectConfirmation, result);
            }
            DateTime notOnOrAfter = subjectConfirmationData.getNotOnOrAfter();
            DateTime now = result.getNow();
            boolean bl = isOnOrAfter = !this.validateNotOnOrAfter(notOnOrAfter, now, result, ResultType.SUBJECT_CONFIRMATION_DATA_MISSING_NOT_ON_OR_AFTER, ResultType.SUBJECT_CONFIRMATION_DATA_IS_ON_OR_AFTER);
            if (notOnOrAfter != null && !isOnOrAfter && this.replayCache != null && !this.replayCache.check("responseId", result.getResponseObject().getID(), notOnOrAfter.getMillis())) {
                result.addResult(ResultType.RESPONSE_ID_REPLAY, Collections.singletonMap("subjectConfirmationData", subjectConfirmationData));
            }
            if (subjConfInResponseTo != null && this.authnStateCache.remove(subjConfInResponseTo) == null) {
                result.addResult(ResultType.SUBJECT_CONFIRMATION_DATA_UNEXPECTED_IN_RESPONSE_TO, Collections.singletonMap("subjectConfirmation", subjectConfirmation));
            }
        }
    }

    private void validateAudienceRestriction(SubjectConfirmation subjectConfirmation, SamlResponseValidationResult result) {
        String expectedAudience;
        Assertion parentAssertion = (Assertion)subjectConfirmation.getParent().getParent();
        Set<String> audiences = this.findAudiences(parentAssertion);
        if (!audiences.contains(expectedAudience = result.getServiceProviderSpi().getIssuerName(result.getRequest()))) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("subjectConfirmation", subjectConfirmation);
            model.put("parentAssertion", parentAssertion);
            model.put("audiences", audiences);
            model.put("expectedAudience", expectedAudience);
            result.addResult(ResultType.SUBJECT_CONFIRMATION_DATA__ASSERTION_MISSING_AUDIENCE_RESTRICTION, model);
        }
    }

    private Set<String> findAudiences(Assertion assertion) {
        if (assertion.getConditions() == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> audiences = new LinkedHashSet<String>();
        for (AudienceRestriction audienceRestriction : assertion.getConditions().getAudienceRestrictions()) {
            for (Audience audience : audienceRestriction.getAudiences()) {
                String audienceURI = audience.getAudienceURI();
                if (audienceURI == null) continue;
                audiences.add(audienceURI);
            }
        }
        return audiences;
    }

    private SubjectConfirmation findSubjectConfirmationBearer(List<Assertion> assertions) {
        for (Assertion assertion : assertions) {
            SubjectConfirmation confirmation = this.findSubjectConfirmationBearer(assertion);
            if (confirmation == null) continue;
            return confirmation;
        }
        return null;
    }

    private SubjectConfirmation findSubjectConfirmationBearer(Assertion assertion) {
        if (assertion.getAuthnStatements() == null || assertion.getAuthnStatements().isEmpty()) {
            return null;
        }
        if (assertion.getSubject() == null || assertion.getSubject().getSubjectConfirmations().isEmpty()) {
            return null;
        }
        for (SubjectConfirmation subjectConfirmation : assertion.getSubject().getSubjectConfirmations()) {
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConfirmation.getMethod())) continue;
            return subjectConfirmation;
        }
        return null;
    }

    private void validateAuthStatement(List<Assertion> assertions, SamlResponseValidationResult result) {
        AuthnStatement authnStatement = this.findFirstAuthnStatement(assertions);
        if (authnStatement == null) {
            result.addResult(ResultType.MISSING_AUTHN_STATEMENT);
        } else if (authnStatement.getSessionNotOnOrAfter() != null) {
            log.warn("SessionNotOnOrAfter was set by IDP, but will not be enforced");
        }
    }

    private AuthnStatement findFirstAuthnStatement(List<Assertion> assertions) {
        for (Assertion assertion : assertions) {
            if (assertion.getAuthnStatements() == null || assertion.getAuthnStatements().isEmpty()) continue;
            return assertion.getAuthnStatements().get(0);
        }
        return null;
    }

    private void validateAssertion(Assertion assertion, SamlResponseValidationResult result) {
        this.validateIssuer(assertion, result);
        this.validateConditions(assertion.getConditions(), result);
        Signature signature = assertion.getSignature();
        if (signature == null) {
            if (result.getResponseObject().getSignature() == null) {
                result.addResult(ResultType.ASSERTION_MISSING_SIGNATURE, Collections.singletonMap("assertion", assertion));
            }
        } else {
            this.validateSignature(assertion, result, null, ResultType.ASSERTION_SIGNATURE_UNKNOWN_SIGNING_CERTIFICATE, ResultType.ASSERTION_SIGNATURE_FAILED_VALIDATION);
        }
    }

    private void validateIssuer(Assertion assertion, SamlResponseValidationResult result) {
        if (assertion.getIssuer() == null) {
            result.addResult(ResultType.ASSERTION_ISSUER_MISSING, Collections.singletonMap("assertion", assertion));
        } else {
            if (assertion.getIssuer().getValue() == null) {
                result.addResult(ResultType.ASSERTION_ISSUER_MISSING_VALUE, Collections.singletonMap("assertion", assertion));
            }
            if (assertion.getIssuer().getFormat() != null && !"urn:oasis:names:tc:SAML:2.0:nameid-format:entity".equals(assertion.getIssuer().getFormat())) {
                result.addResult(ResultType.ASSERTION_ISSUER_UNEXPECTED_FORMAT, Collections.singletonMap("assertion", assertion));
            }
        }
    }

    private void validateConditions(Conditions conditions, SamlResponseValidationResult result) {
        if (conditions == null) {
            result.addResult(ResultType.MISSING_ASSERTION_CONDITIONS);
        } else {
            for (Condition condition : conditions.getConditions()) {
                if (condition instanceof AudienceRestriction) continue;
                log.warn("Non-AudienceRestriction condition (will not be enforced): " + condition.getElementQName());
            }
            DateTime now = result.getNow();
            DateTime notBefore = conditions.getNotBefore();
            if (notBefore == null) {
                result.addResult(ResultType.MISSING_ASSERTION_CONDITION_NOT_BEFORE);
            } else if (now.plusSeconds(60).isBefore(notBefore.toInstant())) {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("now", now);
                model.put("notBefore", notBefore);
                result.addResult(ResultType.ASSERTION_CONDITION_NOT_BEFORE_FAILED, model);
            }
            DateTime notOnOrAfter = conditions.getNotOnOrAfter();
            if (notOnOrAfter == null) {
                result.addResult(ResultType.MISSING_ASSERTION_CONDITION_NOT_ON_OR_AFTER);
            } else if (this.isOnOrAfter(now, notOnOrAfter)) {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("now", now);
                model.put("notOnOrAfter", notOnOrAfter);
                result.addResult(ResultType.ASSERTION_CONDITION_NOT_ON_OR_AFTER_FAILED, model);
            }
        }
    }
}

