/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.samllib.validation;

import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.kantega.samllib.validation.AbstractSamlValidationResult;
import org.kantega.samllib.validation.SAMLSessionIdentification;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;

public class SamlResponseValidationResult
extends AbstractSamlValidationResult {
    private String authnRequestID;
    private Response responseObject;
    private boolean responseSignatureValidated;
    private List<Assertion> decryptedAssertions;
    private SAMLSessionIdentification sessionIdentification;

    public SamlResponseValidationResult(HttpServletRequest request, HttpServletResponse response, ServiceProviderSpi serviceProviderSpi, DateTime now) {
        super(request, response, serviceProviderSpi, now);
    }

    public void setResponseObject(Response responseObject) {
        this.responseObject = responseObject;
        this.authnRequestID = responseObject.getInResponseTo();
    }

    public void setDecryptedAssertions(List<Assertion> decryptedAssertions) {
        this.decryptedAssertions = decryptedAssertions;
    }

    public Response getResponseObject() {
        return this.responseObject;
    }

    public String getAuthnRequestID() {
        return this.authnRequestID;
    }

    public void setAuthnRequestID(String authnRequestID) {
        this.authnRequestID = authnRequestID;
    }

    public void setResponseSignatureValidated(boolean responseSignatureValidated) {
        this.responseSignatureValidated = responseSignatureValidated;
    }

    public boolean isResponseSignatureValidated() {
        return this.responseSignatureValidated;
    }

    public List<Assertion> getDecryptedAssertions() {
        return this.decryptedAssertions;
    }

    public List<Assertion> getAssertions() {
        return this.hasDecryptedAssertions() ? this.decryptedAssertions : this.responseObject.getAssertions();
    }

    public boolean hasDecryptedAssertions() {
        return this.decryptedAssertions != null && !this.decryptedAssertions.isEmpty();
    }

    public void setSessionIdentification(SAMLSessionIdentification sessionIdentification) {
        this.sessionIdentification = sessionIdentification;
    }

    public Optional<SAMLSessionIdentification> getSessionIdentification() {
        return Optional.ofNullable(this.sessionIdentification);
    }
}

