/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.samllib.validation;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.joda.time.DateTime;
import org.kantega.samllib.Binding;
import org.kantega.samllib.spi.ServiceProviderSpi;
import org.kantega.samllib.validation.AbstractSamlValidator;
import org.kantega.samllib.validation.ResultType;
import org.kantega.samllib.validation.SAMLSessionIdentification;
import org.kantega.samllib.validation.SamlLogoutValidationResult;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.saml2.binding.security.impl.SAML2HTTPRedirectDeflateSignatureSecurityHandler;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.SessionIndex;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlLogoutObjectValidator
extends AbstractSamlValidator {
    private static final Logger log = LoggerFactory.getLogger(SamlLogoutObjectValidator.class);

    public SamlLogoutObjectValidator(ServiceProviderSpi serviceProviderSpi) {
        super(serviceProviderSpi);
    }

    public void validateLogoutResponse(MessageContext<SAMLObject> ctx, Binding binding, SamlLogoutValidationResult result) {
        LogoutResponse logoutResponse = (LogoutResponse)ctx.getMessage();
        HttpServletRequest req = result.getRequest();
        assert (logoutResponse != null);
        result.setLogoutResponse(logoutResponse);
        this.validateStatus(logoutResponse.getStatus(), result);
        String logoutLocation = this.serviceProviderSpi.getLogoutLocation(req);
        String destination = logoutResponse.getDestination();
        this.validateDestination(result, destination, logoutLocation, ResultType.LOGOUT_RESPONSE_DESTINATION_MISSING_VALUE, ResultType.LOGOUT_RESPONSE_DESTINATION_INVALID);
        this.validateBindingSignature(ctx, binding, result);
    }

    public void validateLogoutRequest(MessageContext<SAMLObject> ctx, Binding binding, SamlLogoutValidationResult result) {
        HttpServletRequest req = result.getRequest();
        LogoutRequest logoutRequest = (LogoutRequest)ctx.getMessage();
        assert (logoutRequest != null);
        result.setLogoutRequest(logoutRequest);
        DateTime notOnOrAfter = logoutRequest.getNotOnOrAfter();
        DateTime now = result.getNow();
        if (notOnOrAfter != null) {
            this.validateNotOnOrAfter(notOnOrAfter, now, result, null, ResultType.LOGOUT_REQUEST_IS_ON_OR_AFTER);
            if (result.hasErrors()) {
                return;
            }
        }
        String destination = logoutRequest.getDestination();
        String logoutLocation = this.serviceProviderSpi.getLogoutLocation(req);
        this.validateDestination(result, destination, logoutLocation, ResultType.LOGOUT_REQUEST_DESTINATION_MISSING_VALUE, ResultType.LOGOUT_REQUEST_DESTINATION_INVALID);
        this.validateSessionIdentification(logoutRequest, result);
        if (result.hasErrors()) {
            return;
        }
        this.validateBindingSignature(ctx, binding, result);
    }

    private void validateBindingSignature(MessageContext<SAMLObject> ctx, Binding binding, SamlLogoutValidationResult result) {
        if (binding == Binding.HTTP_REDIRECT) {
            this.validateOOBSignature(ctx, result);
        } else if (binding == Binding.HTTP_POST) {
            SignableSAMLObject signable = (SignableSAMLObject)ctx.getMessage();
            this.validateSignature(signable, result, ResultType.LOGOUT_REQUEST_MISSING_SIGNATURE, ResultType.LOGOUT_REQUEST_SIGNATURE_UNKNOWN_SIGNING_CERTIFICATE, ResultType.LOGOUT_REQUEST_SIGNATURE_FAILED_VALIDATION);
        } else {
            result.addResult(ResultType.UNSUPPORTED_BINDING);
        }
    }

    private void validateSessionIdentification(LogoutRequest logoutRequest, SamlLogoutValidationResult result) {
        NameID nameID = logoutRequest.getNameID();
        if (nameID == null || nameID.getValue().isEmpty()) {
            result.addResult(ResultType.LOGOUT_REQUEST_MISSING_NAME_ID);
            return;
        }
        SAMLSessionIdentification.ValidationPolicy policy = this.serviceProviderSpi.getSessionIdentificationValidationPolicy();
        if (policy == SAMLSessionIdentification.ValidationPolicy.RELAXED) {
            return;
        }
        SAMLSessionIdentification sessionIdentification = this.serviceProviderSpi.getSessionIdentification(result.getRequest()).orElse(null);
        if (sessionIdentification == null) {
            result.addResult(ResultType.LOGOUT_REQUEST_UNKNOWN_PRINCIPAL);
            return;
        }
        if (policy == SAMLSessionIdentification.ValidationPolicy.NAME_ID_ONLY && !sessionIdentification.getNameId().equals(nameID.getValue())) {
            result.addResult(ResultType.LOGOUT_REQUEST_UNKNOWN_PRINCIPAL);
            return;
        }
        if (policy == SAMLSessionIdentification.ValidationPolicy.EXACT) {
            boolean sessionIndexMatch;
            List<SessionIndex> requestedIndexes = logoutRequest.getSessionIndexes();
            boolean nameIdMatch = sessionIdentification.getNameId().equals(nameID.getValue());
            boolean bl = sessionIndexMatch = requestedIndexes.isEmpty() || requestedIndexes.stream().anyMatch(idx -> idx.getSessionIndex().equals(sessionIdentification.getSessionIndex()));
            if (!nameIdMatch || !sessionIndexMatch) {
                result.addResult(ResultType.LOGOUT_REQUEST_UNKNOWN_PRINCIPAL);
            }
        }
    }

    private void validateOOBSignature(MessageContext<SAMLObject> ctx, SamlLogoutValidationResult result) {
        try {
            SecurityParametersContext securityParametersContext = ctx.getSubcontext(SecurityParametersContext.class, true);
            SAMLProtocolContext protocolContext = ctx.getSubcontext(SAMLProtocolContext.class, true);
            SAMLPeerEntityContext peerEntityContext = ctx.getSubcontext(SAMLPeerEntityContext.class, true);
            SignatureValidationParameters validationParameters = new SignatureValidationParameters();
            StaticCredentialResolver credentialResolver = new StaticCredentialResolver(this.serviceProviderSpi.getAllIdentityProviderCredentials());
            StaticKeyInfoCredentialResolver keyInfoResolver = new StaticKeyInfoCredentialResolver(Collections.emptyList());
            validationParameters.setSignatureTrustEngine(new ExplicitKeySignatureTrustEngine(credentialResolver, keyInfoResolver));
            securityParametersContext.setSignatureValidationParameters(validationParameters);
            peerEntityContext.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
            protocolContext.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
            SAML2HTTPRedirectDeflateSignatureSecurityHandler signatureSecurityHandler = new SAML2HTTPRedirectDeflateSignatureSecurityHandler();
            signatureSecurityHandler.setHttpServletRequest(result.getRequest());
            signatureSecurityHandler.initialize();
            signatureSecurityHandler.invoke(ctx);
        }
        catch (ComponentInitializationException | MessageHandlerException e) {
            log.debug("Signature validation failed", (Throwable)e);
            result.addResult(ResultType.LOGOUT_REQUEST_SIGNATURE_FAILED_VALIDATION);
        }
    }
}

