/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.samllib.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.impl.KeyStoreX509CredentialAdapter;

public class SamlKeyGenerator {
    public static final String KEY_ALIAS = "myKey";
    public static final String CERT_ALIAS = "myCert";
    private final SecureRandom random;
    public static final String defaultPassword = "changeit";

    public SamlKeyGenerator(SecureRandom random) {
        this.random = random;
    }

    public KeyStore generateKeyStore(String hostname, String secretKeyPassword) {
        try {
            KeyStore signingKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            signingKeyStore.load(null, null);
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048, this.random);
            KeyPair keyPair = generator.generateKeyPair();
            PrivateKey priv = keyPair.getPrivate();
            PublicKey pub = keyPair.getPublic();
            String dn = "CN=" + hostname;
            JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(new X500Name(dn), BigInteger.valueOf(1L), new Date(), new Date(System.currentTimeMillis() + 94608000000L), new X500Name(dn), pub);
            ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(priv);
            X509Certificate selfSignedCertificate = new JcaX509CertificateConverter().getCertificate(certificateBuilder.build(contentSigner));
            selfSignedCertificate.checkValidity(new Date());
            selfSignedCertificate.verify(selfSignedCertificate.getPublicKey());
            signingKeyStore.setKeyEntry(KEY_ALIAS, priv, this.nullSafePassword(secretKeyPassword), new X509Certificate[]{selfSignedCertificate});
            signingKeyStore.setCertificateEntry(CERT_ALIAS, selfSignedCertificate);
            return signingKeyStore;
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException | OperatorCreationException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeKeyStore(File file, KeyStore signingKeyStore) {
        OutputStream out = null;
        try {
            file.getParentFile().mkdirs();
            out = new FileOutputStream(file);
            signingKeyStore.store(out, defaultPassword.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getSigningCertificate(File signingKeys) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream is = null;
            try {
                is = new FileInputStream(signingKeys);
                keyStore.load(is, defaultPassword.toCharArray());
                Certificate cert = keyStore.getCertificate(CERT_ALIAS);
                byte[] byArray = cert.getEncoded();
                return byArray;
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential getSpSigningCredentials(File jksFile, String samlPrivateKeyPassword) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] password = defaultPassword.toCharArray();
            try (FileInputStream is = null;){
                is = new FileInputStream(jksFile);
                keyStore.load(is, password);
            }
            return new KeyStoreX509CredentialAdapter(keyStore, KEY_ALIAS, this.nullSafePassword(samlPrivateKeyPassword));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key getPrivateKey(File jksFile, String keyPassword) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] password = defaultPassword.toCharArray();
            try (FileInputStream is = null;){
                is = new FileInputStream(jksFile);
                keyStore.load(is, password);
            }
            return keyStore.getKey(KEY_ALIAS, this.nullSafePassword(keyPassword));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePassword(File keyFile, String currentPassword, String newPassword) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] password = defaultPassword.toCharArray();
            try (FileInputStream is = null;){
                is = new FileInputStream(keyFile);
                keyStore.load(is, password);
            }
            Key privateKey = keyStore.getKey(KEY_ALIAS, this.nullSafePassword(currentPassword));
            Certificate cert = keyStore.getCertificate(CERT_ALIAS);
            keyStore.setKeyEntry(KEY_ALIAS, privateKey, this.nullSafePassword(newPassword), new Certificate[]{cert});
            this.writeKeyStore(keyFile, keyStore);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private char[] nullSafePassword(String password) {
        return (password == null ? defaultPassword : password).toCharArray();
    }
}

