/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.utils;

import org.checkerframework.checker.nullness.qual.NonNull;

public class Version
implements Comparable<Version> {
    public final @NonNull int[] numbers;
    public final @NonNull String value;

    public Version(@NonNull String version) {
        this.value = version;
        if (version.length() > 0) {
            String[] split = version.split("-")[0].split("\\.");
            this.numbers = new int[split.length];
            for (int i = 0; i < split.length; ++i) {
                this.numbers[i] = Integer.parseInt(split[i]);
            }
        } else {
            this.numbers = new int[0];
        }
    }

    public static Version empty() {
        return new Version("");
    }

    @Override
    public int compareTo(@NonNull Version another) {
        int maxLength = Math.max(this.numbers.length, another.numbers.length);
        for (int i = 0; i < maxLength; ++i) {
            int otherVersion;
            int thisVersion = i < this.numbers.length ? this.numbers[i] : 0;
            int n = otherVersion = i < another.numbers.length ? another.numbers[i] : 0;
            if (thisVersion == otherVersion) continue;
            return thisVersion < otherVersion ? -1 : 1;
        }
        return 0;
    }
}

