/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim.admin;

import com.atlassian.templaterenderer.TemplateRenderer;
import io.vavr.control.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.DateTool;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;

public class ShowScimEventsAction
extends RequireAdminServlet {
    private final ScimConfManager scimConfManager;
    private final TemplateRenderer renderer;

    @Inject
    public ShowScimEventsAction(RequireAdminServletDependencyBucket bucket, ScimConfManager scimConfManager) {
        super(bucket);
        this.renderer = bucket.getTemplateRenderer();
        this.scimConfManager = scimConfManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String tenantId = this.getId(req);
        ScimDirectory directory = this.scimConfManager.getScimDirectory(tenantId).getOrElseThrow(() -> new RuntimeException("SCIM tenant not found: " + tenantId));
        Map<String, Object> model = this.newModel(req);
        this.renderPage(resp, model, directory);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String tenantId = this.getId(req);
        Option<ScimDirectory> maybeDirectory = this.scimConfManager.getScimDirectory(tenantId);
        if (maybeDirectory.isEmpty()) {
            resp.sendError(404);
            return;
        }
        if (req.getParameter("clear") != null) {
            this.scimConfManager.clearProvisioningEvents(tenantId);
        }
        resp.sendRedirect("events/" + tenantId);
    }

    private void renderPage(HttpServletResponse res, Map<String, Object> model, ScimDirectory directory) throws IOException {
        model.put("topMenu", "connectors");
        model.put("menuItem", "provEvents");
        model.put("currentScimDirectory", directory);
        model.put("dateTool", new DateTool());
        model.put("events", this.scimConfManager.getProvisioningEvents(directory.getTenantId()).reverse());
        res.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/scim/scim-events.vm", model, (Writer)res.getWriter());
    }

    private String getId(HttpServletRequest req) {
        String p = req.getPathInfo();
        return p.substring(p.lastIndexOf("/") + 1);
    }
}

