/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim.admin;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.ksso.scim.ScimProviderKind;
import com.ksso.scim.atlassian.auth.BasicAuthCredentials;
import com.ksso.scim.atlassian.auth.BearerTokenCredentials;
import com.ksso.scim.atlassian.auth.Credentials;
import com.ksso.scim.atlassian.auth.ScimAuthMethod;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.scim.ScimDirectory;
import org.kantega.atlaskerb.scim.ScimTenantConfig;

@Scanned
public class EditScimDirectoryAction
extends RequireAdminServlet {
    private final ApplicationProperties applicationProperties;
    private final ScimConfManager scimConfManager;
    private final TemplateRenderer renderer;

    @Inject
    public EditScimDirectoryAction(RequireAdminServletDependencyBucket bucket, ScimConfManager scimConfManager) {
        super(bucket);
        this.applicationProperties = bucket.getApplicationProperties();
        this.renderer = bucket.getTemplateRenderer();
        this.scimConfManager = scimConfManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String tenantId = req.getParameter("tenantId");
        if (StringUtils.isBlank(tenantId)) {
            resp.sendError(404);
            return;
        }
        Map<String, Object> model = this.newModel(req);
        ScimDirectory scimDirectory = this.getScimDirectory(tenantId);
        ScimTenantConfig config = scimDirectory.getConfig();
        model.put("currentScimDirectory", scimDirectory);
        model.put("tenantId", tenantId);
        model.put("directoryName", config.getTenantName());
        model.put("authMethod", config.getScimAuthMethod().toString());
        model.put("kind", config.getKind().name());
        this.renderPage(resp, model);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String salt;
        HashSet<String> missingFields = new HashSet<String>();
        String tenantId = req.getParameter("tenantId");
        String kind = req.getParameter("kind");
        String directoryName = req.getParameter("directoryName");
        if (StringUtils.isBlank(directoryName)) {
            missingFields.add("directoryName");
        }
        String applicationSecretPlainText = req.getParameter("applicationSecret");
        String passwordPlainText = req.getParameter("password");
        ScimDirectory existingDirectory = this.getScimDirectory(tenantId);
        ScimTenantConfig existingConfig = existingDirectory.getConfig();
        ScimAuthMethod authMethod = existingConfig.getScimAuthMethod();
        if (!missingFields.isEmpty()) {
            Map<String, Object> model = this.newModel(req);
            model.put("missingFields", missingFields);
            model.put("tenantId", tenantId);
            model.put("kind", kind);
            model.put("directoryName", directoryName);
            model.put("authMethod", authMethod.toString());
            if (authMethod == ScimAuthMethod.BEARER) {
                model.put("applicationSecret", applicationSecretPlainText);
            } else if (authMethod == ScimAuthMethod.BASIC) {
                model.put("username", tenantId);
                model.put("password", passwordPlainText);
            }
            this.renderPage(resp, model);
            return;
        }
        Credentials credentials = existingConfig.getCredentials();
        String placeholderText = "********";
        if (authMethod == ScimAuthMethod.BEARER) {
            if (StringUtils.isNotBlank(applicationSecretPlainText) && !StringUtils.equals("********", applicationSecretPlainText)) {
                salt = this.scimConfManager.nextId();
                credentials = BearerTokenCredentials.createHash(salt, applicationSecretPlainText);
            }
        } else if (authMethod == ScimAuthMethod.BASIC && StringUtils.isNotBlank(passwordPlainText) && !StringUtils.equals("********", passwordPlainText)) {
            salt = this.scimConfManager.nextId();
            credentials = BasicAuthCredentials.createHash(tenantId, salt, passwordPlainText);
        }
        ScimTenantConfig newCfg = new ScimTenantConfig(tenantId, directoryName, credentials, authMethod, ScimProviderKind.valueOf(kind));
        this.scimConfManager.saveOrUpdate(newCfg);
        resp.sendRedirect("directory/" + tenantId);
    }

    private ScimDirectory getScimDirectory(String tenantId) {
        return this.scimConfManager.getScimDirectory(tenantId).getOrElseThrow(() -> new RuntimeException("SCIM tenantId not found: " + tenantId));
    }

    private void renderPage(HttpServletResponse resp, Map<String, Object> model) throws IOException {
        model.put("topMenu", "connectors");
        model.put("menuItem", "editScimDirectory");
        model.put("displayName", this.applicationProperties.getDisplayName());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/scim/edit-scim-directory.vm", model, (Writer)resp.getWriter());
    }
}

