/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.scim;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.ksso.scim.ScimServlet;
import com.ksso.scim.spi.ScimServerSpi;
import io.vavr.control.Either;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class AtlScimServlet
extends ScimServlet {
    private static final Logger log = LoggerFactory.getLogger(AtlScimServlet.class);
    private final ScimConfManager scimConfManager;
    private final PluginLicenseManager licenseManager;
    private final boolean iAmApiServer;

    @Inject
    public AtlScimServlet(ScimConfManager scimConfManager, PluginLicenseManager licenseManager) {
        this.scimConfManager = scimConfManager;
        this.licenseManager = licenseManager;
        this.iAmApiServer = false;
    }

    public AtlScimServlet(ScimConfManager scimConfManager, PluginLicenseManager licenseManager, boolean iAmApiServer) {
        this.scimConfManager = scimConfManager;
        this.licenseManager = licenseManager;
        this.iAmApiServer = iAmApiServer;
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.iAmApiServer && !this.scimConfManager.isScimBaseUrlEndpointEnabled()) {
            log.warn("SCIM on baseURL has been disabled");
            res.setStatus(404);
            return;
        }
        if (!this.isLicenseValid()) {
            res.setStatus(500);
            String msg = "License error: App license for Kantega SSO is not valid. Consult UPM for details.";
            res.getWriter().print(msg);
            log.warn(msg);
            return;
        }
        super.service(req, res);
    }

    @Override
    protected Either<String, ScimServerSpi> getScimServerSpi(String tenantId) {
        return this.scimConfManager.getScimServerSpi(tenantId).toEither(String.format("Tenant '%s' is unknown or disabled", tenantId));
    }

    private boolean isLicenseValid() {
        Option license = this.licenseManager.getLicense();
        if (!license.isDefined()) {
            return false;
        }
        return ((PluginLicense)license.get()).isValid();
    }
}

