/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.cert;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobRunnerKey;
import io.vavr.collection.LinearSeq;
import io.vavr.control.Either;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.net.ssl.HttpsURLConnection;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.identityproviders.IdpConfigurationBuilder;
import org.kantega.atlaskerb.saml.FingerprintSSLSocketFactory;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.MetadataParser;
import org.kantega.atlaskerb.saml.SAMLIdpConfiguration;
import org.kantega.atlaskerb.utils.ErrorUtils;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpdateCertMetadataJobRunner
implements JobRunner {
    public static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)(UpdateCertMetadataJobRunner.class + ".job"));
    private static final Logger log = LoggerFactory.getLogger(UpdateCertMetadataJobRunner.class);
    private final IdpConfManager idpConfManager;

    @Inject
    public UpdateCertMetadataJobRunner(IdpConfManager idpConfManager) {
        this.idpConfManager = idpConfManager;
    }

    public Try<io.vavr.collection.List<Either<SAMLIdpConfiguration, SAMLIdpConfiguration>>> refreshSamlCertificatesFromMetadata() {
        MetadataParser metadataParser = new MetadataParser();
        return Try.of(this.idpConfManager::getIdentityProviders).mapTry(io.vavr.collection.List::ofAll).mapTry(idps -> idps.filter(idpConfiguration -> idpConfiguration instanceof SAMLIdpConfiguration).map(SAMLIdpConfiguration.class::cast).filter(SAMLIdpConfiguration::isAutoRefreshMetadataEnabled).map(idp -> {
            String fingerprint = Option.of(idp.getTlsFingerprint()).getOrElse("");
            Try<String> maybeMetadataURLSaved = Try.of(idp::getMetadataURL);
            return maybeMetadataURLSaved.mapTry(URI::new).mapTry(URI::toURL).mapTry(URL::openConnection).mapTry(HttpURLConnection.class::cast).flatMapTry(connection -> this.checkHttpURLConnectionSSL(fingerprint, (HttpURLConnection)connection)).mapTry(URLConnection::getInputStream).mapTry(metadataParser::parse).onFailure(e -> log.warn(ErrorUtils.createErrorMessage("KSSO-2N243PO7IF", String.format("Failed to automatically update metadata for IdP %s (%s), requesting metadata URL %s", idp.getName(), idp.getId(), maybeMetadataURLSaved.getOrElse(""))), e)).onSuccess(metadata -> {
                IDPSSODescriptor idpDesc = metadataParser.getIDPDescriptorForSaml((EntityDescriptor)metadata);
                List<byte[]> signingCerts = metadataParser.getSigningCerts(idpDesc);
                MetadataParser.IdpSsoLocation idpLocation = metadataParser.getIdpSsoLocation(idpDesc);
                String idpSingleLogoutServiceURL = metadataParser.getIdpSingleLogoutServiceURL(idpDesc);
                IdpConfigurationBuilder.SAML builder = IdpConfigurationBuilder.of(idp);
                builder.setIdpUrl(idpLocation.getLocation());
                builder.setUsePostBinding(idpLocation.usePostBinding());
                builder.setIdpSingleLogoutServiceURL(idpSingleLogoutServiceURL);
                builder.setSigningCerts(signingCerts);
                this.idpConfManager.updateIdpConfiguration((IdpConfiguration)builder.build());
                log.debug(String.format("Successfully updated SAML metadata for %s (%s)", idp.getName(), idp.getId()));
            }).fold(_throwable -> Either.left(idp), _metadata -> Either.right(idp)).bimap(SAMLIdpConfiguration.class::cast, SAMLIdpConfiguration.class::cast);
        })).onFailure(e -> log.error(ErrorUtils.createErrorMessage("KSSO-IT8GST58N7", "Exception updating SAML certificate metadata: "), e));
    }

    private Try<HttpURLConnection> checkHttpURLConnectionSSL(String fingerprint, HttpURLConnection maybeConnection) {
        return Try.of(() -> maybeConnection).mapTry(connection -> {
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                httpsConnection.setSSLSocketFactory(new FingerprintSSLSocketFactory(fingerprint));
                return httpsConnection;
            }
            return connection;
        });
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        Try<io.vavr.collection.List<Either<SAMLIdpConfiguration, SAMLIdpConfiguration>>> refreshedIdps = this.refreshSamlCertificatesFromMetadata();
        if (refreshedIdps.isSuccess()) {
            io.vavr.collection.List<Either<SAMLIdpConfiguration, SAMLIdpConfiguration>> idpsUpdated = refreshedIdps.get();
            return JobRunnerResponse.success((String)this.formatMessageReport(idpsUpdated));
        }
        Throwable e = refreshedIdps.getCause();
        return JobRunnerResponse.failed((String)("Exception updating SAML certificate metadata: " + e.getClass() + ": " + e.getMessage()));
    }

    private String formatMessageReport(io.vavr.collection.List<Either<SAMLIdpConfiguration, SAMLIdpConfiguration>> idpsUpdated) {
        return Try.of(() -> {
            LinearSeq failedIdps = idpsUpdated.filter(Either::isLeft).map(Either::getLeft).map(failedIdp -> String.format("%s (%s)", failedIdp.getName(), failedIdp.getId()));
            LinearSeq successIdps = idpsUpdated.filter(Either::isRight).map(Either::get).map(idp -> String.format("%s (%s)", idp.getName(), idp.getId()));
            if (failedIdps.nonEmpty()) {
                return String.format("Failed to update SAML metadata for IdP(s): [%s]", failedIdps.intersperse(", ").foldLeft("", String::concat));
            }
            if (successIdps.nonEmpty()) {
                return String.format("Successfully updated SAML metadata for %d IdP(s)", successIdps.size());
            }
            return "";
        }).getOrElse("");
    }
}

