/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import java.util.concurrent.TimeUnit;
import org.kantega.samllib.spi.AuthnState;
import org.kantega.samllib.spi.AuthnStateCache;

public class AtlassianAuthnStateCache
implements AuthnStateCache {
    private final Cache<String, AuthnState> cache;

    public AtlassianAuthnStateCache(CacheManager cacheManager) {
        String name = AtlassianAuthnStateCache.class.getName() + ".authnStateCache";
        this.cache = cacheManager.getCache(name, null, new CacheSettingsBuilder().remote().replicateViaCopy().replicateAsynchronously().expireAfterWrite(30L, TimeUnit.MINUTES).maxEntries(Integer.parseInt(System.getProperty(name, "25000"))).build());
    }

    @Override
    public void put(String authnRequestId, AuthnState state) {
        this.cache.put((Object)authnRequestId, (Object)state);
    }

    @Override
    public AuthnState remove(String authnRequestId) {
        AuthnState state = (AuthnState)this.cache.get((Object)authnRequestId);
        this.cache.remove((Object)authnRequestId);
        return state;
    }
}

