/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.ApplicationProperties;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.saml.IdpConfManager;

@Scanned
public class UserSyncServlet
extends RequireAdminServlet {
    private final IdpConfManager idpConfManager;
    private final ApplicationProperties applicationProperties;
    private final ConnectorConfManager connectorConfManager;

    @Inject
    public UserSyncServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.idpConfManager = bucket.getIdpConfManager();
        this.applicationProperties = bucket.getApplicationProperties();
        this.connectorConfManager = bucket.getConnectorConfManager();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> model = this.newModel(req);
        resp.setContentType("text/html");
        String id = this.getId(req);
        IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(id);
        if (configuration == null) {
            resp.sendError(404);
            return;
        }
        model.put("topMenu", "SAML");
        model.put("menuItem", "userGroupSync");
        model.put("idp", configuration);
        model.put("displayName", this.applicationProperties.getDisplayName());
        model.put("connectorTypes", this.connectorConfManager.getConnectorTypes());
        model.put("matchingConnectors", this.connectorConfManager.findMatchingConnectors(configuration.getKind()));
        model.put("matchingConnectorType", this.connectorConfManager.findMatchingConnectorType(configuration.getKind()));
        this.getTemplateRenderer().render("templates/saml/user-group-sync.vm", model, (Writer)resp.getWriter());
    }

    private String getId(HttpServletRequest req) {
        String p = req.getPathInfo();
        p = p.substring(0, p.lastIndexOf("/"));
        return p.substring(p.lastIndexOf("/") + 1);
    }
}

