/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.saml;

import java.util.Date;
import java.util.Properties;
import org.joda.time.format.ISODateTimeFormat;
import org.kantega.atlaskerb.identityproviders.ResponseEvaluationCode;

public class TestRecord {
    private final String id;
    private final Date lastModified;
    private final Properties props;

    public TestRecord(String id, Date lastModified, Properties props) {
        this.id = id;
        this.lastModified = lastModified;
        this.props = props;
    }

    public String getId() {
        return this.id;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getRequestAddress() {
        return this.props.getProperty("requestAddress");
    }

    public String getResponseAddress() {
        return this.props.getProperty("responseAddress");
    }

    public Date getRequestTime() {
        return ISODateTimeFormat.dateTimeParser().parseDateTime(this.props.getProperty("requestTime")).toDate();
    }

    public Date getResponseTime() {
        String responseTime = this.props.getProperty("responseTime");
        return responseTime == null ? null : ISODateTimeFormat.dateTimeParser().parseDateTime(responseTime).toDate();
    }

    public ResponseEvaluationCode getCode() {
        String code = this.props.getProperty("code");
        if (code == null) {
            return ResponseEvaluationCode.WAITING_FOR_RESPONSE;
        }
        return ResponseEvaluationCode.valueOf(code);
    }

    public String getUsername() {
        return this.props.getProperty("username");
    }

    public String getFullname() {
        return this.props.getProperty("fullname");
    }
}

